/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.functions;

import com.google.common.base.Function;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.cloudsigma.domain.ProfileInfo;
import org.jclouds.cloudsigma.domain.ProfileType;
import org.jclouds.logging.Logger;

@Singleton
public class MapToProfileInfo
implements Function<Map<String, String>, ProfileInfo> {
    @Resource
    protected Logger logger = Logger.NULL;

    @Override
    public ProfileInfo apply(Map<String, String> from) {
        if (from.size() == 0) {
            return null;
        }
        if (from.size() == 0) {
            return null;
        }
        ProfileInfo.Builder builder = new ProfileInfo.Builder();
        builder.uuid(from.get("uuid"));
        builder.email(from.get("email"));
        builder.firstName(from.get("first_name"));
        builder.lastName(from.get("last_name"));
        builder.nickName(from.get("nick_name"));
        builder.type(ProfileType.fromValue(from.get("type")));
        try {
            return builder.build();
        }
        catch (NullPointerException e) {
            this.logger.trace("entry missing data: %s; %s", e.getMessage(), from);
            return null;
        }
    }
}

