/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.cloudservers.compute.extensions.CloudServersImageExtension;
import org.jclouds.cloudservers.compute.functions.CloudServersImageToImage;
import org.jclouds.cloudservers.compute.functions.CloudServersImageToOperatingSystem;
import org.jclouds.cloudservers.compute.functions.FlavorToHardware;
import org.jclouds.cloudservers.compute.functions.ServerToNodeMetadata;
import org.jclouds.cloudservers.compute.predicates.GetImageWhenStatusActivePredicateWithResult;
import org.jclouds.cloudservers.compute.strategy.CloudServersComputeServiceAdapter;
import org.jclouds.cloudservers.domain.Flavor;
import org.jclouds.cloudservers.domain.Image;
import org.jclouds.cloudservers.domain.ImageStatus;
import org.jclouds.cloudservers.domain.Server;
import org.jclouds.cloudservers.domain.ServerStatus;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.domain.Location;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.predicates.PredicateWithResult;

public class CloudServersComputeServiceContextModule
extends ComputeServiceAdapterContextModule<Server, Flavor, Image, Location> {
    @VisibleForTesting
    public static final Map<ServerStatus, NodeMetadata.Status> toPortableNodeStatus = ImmutableMap.builder().put(ServerStatus.ACTIVE, NodeMetadata.Status.RUNNING).put(ServerStatus.SUSPENDED, NodeMetadata.Status.SUSPENDED).put(ServerStatus.DELETED, NodeMetadata.Status.TERMINATED).put(ServerStatus.QUEUE_RESIZE, NodeMetadata.Status.PENDING).put(ServerStatus.PREP_RESIZE, NodeMetadata.Status.PENDING).put(ServerStatus.RESIZE, NodeMetadata.Status.PENDING).put(ServerStatus.VERIFY_RESIZE, NodeMetadata.Status.PENDING).put(ServerStatus.QUEUE_MOVE, NodeMetadata.Status.PENDING).put(ServerStatus.PREP_MOVE, NodeMetadata.Status.PENDING).put(ServerStatus.MOVE, NodeMetadata.Status.PENDING).put(ServerStatus.VERIFY_MOVE, NodeMetadata.Status.PENDING).put(ServerStatus.RESCUE, NodeMetadata.Status.PENDING).put(ServerStatus.ERROR, NodeMetadata.Status.ERROR).put(ServerStatus.BUILD, NodeMetadata.Status.PENDING).put(ServerStatus.RESTORING, NodeMetadata.Status.PENDING).put(ServerStatus.PASSWORD, NodeMetadata.Status.PENDING).put(ServerStatus.REBUILD, NodeMetadata.Status.PENDING).put(ServerStatus.DELETE_IP, NodeMetadata.Status.PENDING).put(ServerStatus.SHARE_IP_NO_CONFIG, NodeMetadata.Status.PENDING).put(ServerStatus.SHARE_IP, NodeMetadata.Status.PENDING).put(ServerStatus.REBOOT, NodeMetadata.Status.PENDING).put(ServerStatus.HARD_REBOOT, NodeMetadata.Status.PENDING).put(ServerStatus.UNKNOWN, NodeMetadata.Status.UNRECOGNIZED).put(ServerStatus.UNRECOGNIZED, NodeMetadata.Status.UNRECOGNIZED).build();
    @VisibleForTesting
    public static final Map<ImageStatus, Image.Status> toPortableImageStatus = ImmutableMap.builder().put(ImageStatus.ACTIVE, Image.Status.AVAILABLE).put(ImageStatus.SAVING, Image.Status.PENDING).put(ImageStatus.PREPARING, Image.Status.PENDING).put(ImageStatus.QUEUED, Image.Status.PENDING).put(ImageStatus.FAILED, Image.Status.ERROR).put(ImageStatus.UNKNOWN, Image.Status.UNRECOGNIZED).put(ImageStatus.UNRECOGNIZED, Image.Status.UNRECOGNIZED).build();

    @Override
    protected void configure() {
        super.configure();
        this.bind(new TypeLiteral<ComputeServiceAdapter<Server, Flavor, Image, Location>>(){}).to(CloudServersComputeServiceAdapter.class);
        this.bind(new TypeLiteral<Function<Server, NodeMetadata>>(){}).to(ServerToNodeMetadata.class);
        this.bind(new TypeLiteral<Function<Image, org.jclouds.compute.domain.Image>>(){}).to(CloudServersImageToImage.class);
        this.bind(new TypeLiteral<Function<Image, OperatingSystem>>(){}).to(CloudServersImageToOperatingSystem.class);
        this.bind(new TypeLiteral<Function<Flavor, Hardware>>(){}).to(FlavorToHardware.class);
        this.bind(new TypeLiteral<Function<Location, Location>>(){}).to((Class)Class.class.cast(IdentityFunction.class));
        this.bind(new TypeLiteral<ImageExtension>(){}).to(CloudServersImageExtension.class);
        this.bind(new TypeLiteral<PredicateWithResult<Integer, org.jclouds.compute.domain.Image>>(){}).to(GetImageWhenStatusActivePredicateWithResult.class);
    }

    @Singleton
    @Provides
    Map<ServerStatus, NodeMetadata.Status> toPortableNodeStatus() {
        return toPortableNodeStatus;
    }

    @Singleton
    @Provides
    Map<ImageStatus, Image.Status> toPortableImageStatus() {
        return toPortableImageStatus;
    }

    @Override
    protected Optional<ImageExtension> provideImageExtension(Injector i) {
        return Optional.of(i.getInstance(ImageExtension.class));
    }
}

