/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudloadbalancers.loadbalancer.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudloadbalancers.CloudLoadBalancersClient;
import org.jclouds.cloudloadbalancers.domain.LoadBalancer;
import org.jclouds.cloudloadbalancers.domain.LoadBalancerRequest;
import org.jclouds.cloudloadbalancers.domain.NodeRequest;
import org.jclouds.cloudloadbalancers.domain.VirtualIP;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.domain.Location;
import org.jclouds.loadbalancer.domain.LoadBalancerMetadata;
import org.jclouds.loadbalancer.strategy.GetLoadBalancerMetadataStrategy;
import org.jclouds.loadbalancer.strategy.LoadBalanceNodesStrategy;
import org.jclouds.logging.Logger;

@Singleton
public class CloudLoadBalancersLoadBalanceNodesStrategy
implements LoadBalanceNodesStrategy {
    @Resource
    @Named(value="jclouds.loadbalancer")
    protected Logger logger = Logger.NULL;
    protected final CloudLoadBalancersClient client;
    protected final GetLoadBalancerMetadataStrategy getLB;

    @Inject
    protected CloudLoadBalancersLoadBalanceNodesStrategy(CloudLoadBalancersClient client, GetLoadBalancerMetadataStrategy getLB) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.getLB = Preconditions.checkNotNull(getLB, "getLB");
    }

    @Override
    public LoadBalancerMetadata createLoadBalancerInLocation(Location location, String name, String protocol, int loadBalancerPort, final int instancePort, Iterable<? extends NodeMetadata> nodes) {
        String region = Preconditions.checkNotNull(location, "location").getId();
        LoadBalancer lb = this.client.getLoadBalancerClient(region).createLoadBalancer(((LoadBalancerRequest.Builder)LoadBalancerRequest.builder().name(name).protocol(protocol.toUpperCase()).port(loadBalancerPort).virtualIPType(VirtualIP.Type.PUBLIC).nodes((Iterable)Iterables.transform(nodes, new Function<NodeMetadata, NodeRequest>(){

            @Override
            public NodeRequest apply(NodeMetadata arg0) {
                return NodeRequest.builder().address(Iterables.get(arg0.getPrivateAddresses(), 0)).port(instancePort).build();
            }
        }))).build());
        return this.getLB.getLoadBalancer(region + "/" + lb.getId());
    }
}

