/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudloadbalancers.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.cloudloadbalancers.domain.LoadBalancer;
import org.jclouds.cloudloadbalancers.functions.ConvertLB;
import org.jclouds.cloudloadbalancers.functions.LB;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.rest.InvocationContext;

public class UnwrapLoadBalancers
implements Function<HttpResponse, Set<LoadBalancer>>,
InvocationContext<UnwrapLoadBalancers> {
    private final ParseJson<Map<String, Set<LB>>> json;
    private final ConvertLB.Factory factory;
    private ConvertLB convertLB;

    @Inject
    UnwrapLoadBalancers(ParseJson<Map<String, Set<LB>>> json, ConvertLB.Factory factory) {
        this.json = Preconditions.checkNotNull(json, "json");
        this.factory = Preconditions.checkNotNull(factory, "factory");
    }

    @Override
    public Set<LoadBalancer> apply(HttpResponse arg0) {
        Map<String, Set<LB>> map = this.json.apply(arg0);
        if (map.size() == 0) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(Iterables.transform((Iterable)Iterables.get(map.values(), 0), this.convertLB));
    }

    @Override
    public UnwrapLoadBalancers setContext(HttpRequest request) {
        return this.setRegion(request.getEndpoint().getHost().substring(0, request.getEndpoint().getHost().indexOf(46)));
    }

    UnwrapLoadBalancers setRegion(String region) {
        this.convertLB = this.factory.createForRegion(region);
        return this;
    }
}

