/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudloadbalancers.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.inject.assistedinject.Assisted;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.cloudloadbalancers.domain.LoadBalancer;
import org.jclouds.cloudloadbalancers.functions.LB;
import org.jclouds.logging.Logger;

public class ConvertLB
implements Function<LB, LoadBalancer> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final String region;

    @Inject
    ConvertLB(@Assisted String region) {
        this.region = region.toUpperCase();
    }

    @Override
    public LoadBalancer apply(LB lb) {
        try {
            LoadBalancer.Builder builder = ((LoadBalancer.Builder)LoadBalancer.builder().region(this.region).name(lb.getName()).port(lb.getPort()).protocol(lb.getProtocol()).algorithm(lb.getAlgorithm()).nodes((Iterable)lb.getNodes())).id(lb.id).status(lb.status).virtualIPs(lb.virtualIps);
            if (lb.cluster.size() == 1) {
                builder.clusterName(Iterables.get(lb.cluster.values(), 0));
            }
            if (lb.sessionPersistence.size() == 1) {
                builder.sessionPersistenceType(Iterables.get(lb.sessionPersistence.values(), 0));
            }
            if (lb.created.size() == 1) {
                builder.created(Iterables.get(lb.created.values(), 0));
            }
            if (lb.updated.size() == 1) {
                builder.updated(Iterables.get(lb.updated.values(), 0));
            }
            if (lb.connectionLogging.size() == 1) {
                builder.connectionLoggingEnabled(Iterables.get(lb.connectionLogging.values(), 0));
            }
            return builder.build();
        }
        catch (NullPointerException e) {
            this.logger.warn(e, "nullpointer found parsing %s", lb);
            throw e;
        }
    }

    public static interface Factory {
        public ConvertLB createForRegion(String var1);
    }
}

