/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudloadbalancers.config;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.net.URI;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudloadbalancers.CloudLoadBalancersAsyncClient;
import org.jclouds.cloudloadbalancers.CloudLoadBalancersClient;
import org.jclouds.cloudloadbalancers.features.LoadBalancerAsyncClient;
import org.jclouds.cloudloadbalancers.features.LoadBalancerClient;
import org.jclouds.cloudloadbalancers.features.NodeAsyncClient;
import org.jclouds.cloudloadbalancers.features.NodeClient;
import org.jclouds.cloudloadbalancers.functions.ConvertLB;
import org.jclouds.cloudloadbalancers.handlers.ParseCloudLoadBalancersErrorFromHttpResponse;
import org.jclouds.cloudloadbalancers.location.RegionUrisFromPropertiesAndAccountIDPathSuffix;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.json.config.GsonModule;
import org.jclouds.location.config.LocationModule;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.openstack.keystone.v1_1.config.AuthenticationServiceModule;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.config.RestClientModule;
import org.jclouds.util.Suppliers2;

@ConfiguresRestClient
public class CloudLoadBalancersRestClientModule
extends RestClientModule<CloudLoadBalancersClient, CloudLoadBalancersAsyncClient> {
    public static final Map<Class<?>, Class<?>> DELEGATE_MAP = ImmutableMap.builder().put(LoadBalancerClient.class, LoadBalancerAsyncClient.class).put(NodeClient.class, NodeAsyncClient.class).build();

    public CloudLoadBalancersRestClientModule() {
        super(DELEGATE_MAP);
    }

    @Override
    protected void installLocations() {
        this.install(new LocationModule());
        this.install(new URIWithAccountIDPathSuffixAuthenticationServiceModule());
    }

    @Override
    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        this.install(new FactoryModuleBuilder().build(ConvertLB.Factory.class));
        super.configure();
    }

    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseCloudLoadBalancersErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseCloudLoadBalancersErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseCloudLoadBalancersErrorFromHttpResponse.class);
    }

    public static class URIWithAccountIDPathSuffixAuthenticationServiceModule
    extends AbstractModule {
        @Override
        protected void configure() {
            this.install(new AuthenticationServiceModule());
            this.bind(RegionIdToURISupplier.class).to(RegionUrisFromPropertiesAndAccountIDPathSuffix.class).in(Scopes.SINGLETON);
        }

        @Provides
        @Singleton
        @Named(value="jclouds.rackspace.account-id")
        protected Supplier<String> accountID(RegionIdToURISupplier.Factory factory, @ApiVersion String apiVersion) {
            return Suppliers2.compose(new Function<URI, String>(){

                @Override
                public String apply(URI arg0) {
                    return arg0.getPath().substring(arg0.getPath().lastIndexOf(47) + 1);
                }

                public String toString() {
                    return "getAccountIdFromCloudServers()";
                }
            }, Suppliers2.getLastValueInMap(factory.createForApiTypeAndVersion("cloudServers", apiVersion)));
        }
    }
}

