/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudfiles;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import com.google.inject.TypeLiteral;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.internal.BaseApiMetadata;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.cloudfiles.CloudFilesAsyncClient;
import org.jclouds.cloudfiles.CloudFilesClient;
import org.jclouds.cloudfiles.blobstore.config.CloudFilesBlobStoreContextModule;
import org.jclouds.cloudfiles.config.CloudFilesRestClientModule;
import org.jclouds.openstack.swift.SwiftApiMetadata;
import org.jclouds.openstack.swift.blobstore.SwiftBlobSigner;
import org.jclouds.openstack.swift.blobstore.config.TemporaryUrlExtensionModule;
import org.jclouds.rest.RestContext;

public class CloudFilesApiMetadata
extends SwiftApiMetadata {
    private static final long serialVersionUID = -1572520638079261710L;
    public static final TypeToken<RestContext<CloudFilesClient, CloudFilesAsyncClient>> CONTEXT_TOKEN = new TypeToken<RestContext<CloudFilesClient, CloudFilesAsyncClient>>(){
        private static final long serialVersionUID = -5070937833892503232L;
    };

    private static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return CloudFilesApiMetadata.builder().fromApiMetadata(this);
    }

    public CloudFilesApiMetadata() {
        this(CloudFilesApiMetadata.builder());
    }

    protected CloudFilesApiMetadata(Builder builder) {
        super(builder);
    }

    public static Properties defaultProperties() {
        Properties properties = SwiftApiMetadata.defaultProperties();
        return properties;
    }

    public static class CloudFilesTemporaryUrlExtensionModule
    extends TemporaryUrlExtensionModule<CloudFilesAsyncClient> {
        @Override
        protected void bindRequestSigner() {
            this.bind(BlobRequestSigner.class).to((TypeLiteral<BlobRequestSigner>)new TypeLiteral<SwiftBlobSigner<CloudFilesAsyncClient>>(){});
        }
    }

    public static class Builder
    extends SwiftApiMetadata.Builder {
        protected Builder() {
            super(CloudFilesClient.class, CloudFilesAsyncClient.class);
            ((BaseApiMetadata.Builder)this.id("cloudfiles").name("Rackspace Cloud Files API").identityName("Username").credentialName("API Key").documentation(URI.create("http://docs.rackspacecloud.com/files/api/v1/cfdevguide_d5/content/ch01.html")).defaultProperties(CloudFilesApiMetadata.defaultProperties()).context(CONTEXT_TOKEN)).defaultModules((Set)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(CloudFilesRestClientModule.StorageAndCDNManagementEndpointModule.class)).add(CloudFilesRestClientModule.class)).add(CloudFilesBlobStoreContextModule.class)).add(CloudFilesTemporaryUrlExtensionModule.class)).build()));
        }

        @Override
        public CloudFilesApiMetadata build() {
            return new CloudFilesApiMetadata(this);
        }

        @Override
        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

