/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.predicates;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.AWSEC2Client;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.predicates.InstancePresent;

@Singleton
public class AWSEC2InstancePresent
extends InstancePresent {
    private final AWSEC2Client client;

    @Inject
    public AWSEC2InstancePresent(AWSEC2Client client) {
        super(client);
        this.client = Preconditions.checkNotNull(client, "client");
    }

    @Override
    protected void refresh(RegionAndName instance) {
        if (instance.getName().indexOf("sir-") != 0) {
            super.refresh(instance);
        } else {
            Iterables.getOnlyElement(this.client.getSpotInstanceServices().describeSpotInstanceRequestsInRegion(instance.getRegion(), instance.getName()));
        }
    }
}

