/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Names;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.compute.AWSEC2ComputeService;
import org.jclouds.aws.ec2.compute.AWSEC2TemplateOptions;
import org.jclouds.aws.ec2.compute.config.ClusterCompute;
import org.jclouds.aws.ec2.compute.config.ImageQuery;
import org.jclouds.aws.ec2.compute.suppliers.CallForImages;
import org.jclouds.aws.ec2.domain.PlacementGroup;
import org.jclouds.aws.ec2.domain.RegionNameAndPublicKeyMaterial;
import org.jclouds.aws.ec2.functions.CreatePlacementGroupIfNeeded;
import org.jclouds.aws.ec2.functions.ImportOrReturnExistingKeypair;
import org.jclouds.aws.ec2.predicates.PlacementGroupAvailable;
import org.jclouds.aws.ec2.predicates.PlacementGroupDeleted;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.config.ValueOfConfigurationKeyOrNull;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.compute.config.EC2ComputeServiceDependenciesModule;
import org.jclouds.ec2.compute.domain.PasswordDataAndPrivateKey;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.extensions.EC2ImageExtension;
import org.jclouds.ec2.compute.functions.CreateUniqueKeyPair;
import org.jclouds.ec2.compute.functions.CredentialsForInstance;
import org.jclouds.ec2.compute.functions.EC2ImageParser;
import org.jclouds.ec2.compute.functions.PasswordCredentialsFromWindowsInstance;
import org.jclouds.ec2.compute.functions.WindowsLoginCredentialsFromEncryptedData;
import org.jclouds.ec2.compute.internal.EC2TemplateBuilderImpl;
import org.jclouds.ec2.compute.loaders.CreateSecurityGroupIfNeeded;
import org.jclouds.ec2.compute.loaders.LoadPublicIpForInstanceOrNull;
import org.jclouds.ec2.compute.loaders.RegionAndIdToImage;
import org.jclouds.ec2.compute.predicates.GetImageWhenStatusAvailablePredicateWithResult;
import org.jclouds.ec2.domain.Image;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.predicates.PredicateWithResult;
import org.jclouds.predicates.RetryablePredicate;

public class AWSEC2ComputeServiceDependenciesModule
extends EC2ComputeServiceDependenciesModule {
    @Override
    protected void configure() {
        this.bind(TemplateBuilder.class).to(EC2TemplateBuilderImpl.class);
        this.bind(TemplateOptions.class).to(AWSEC2TemplateOptions.class);
        this.bind(ComputeService.class).to(AWSEC2ComputeService.class);
        this.bind(new TypeLiteral<CacheLoader<RunningInstance, LoginCredentials>>(){}).to(CredentialsForInstance.class);
        this.bind(new TypeLiteral<CacheLoader<RegionAndName, String>>(){}).annotatedWith(Names.named("SECURITY")).to(CreateSecurityGroupIfNeeded.class);
        this.bind(new TypeLiteral<CacheLoader<RegionAndName, String>>(){}).annotatedWith(Names.named("ELASTICIP")).to(LoadPublicIpForInstanceOrNull.class);
        this.bind(new TypeLiteral<Function<PasswordDataAndPrivateKey, LoginCredentials>>(){}).to(WindowsLoginCredentialsFromEncryptedData.class);
        this.bind(new TypeLiteral<Function<RunningInstance, LoginCredentials>>(){}).to(PasswordCredentialsFromWindowsInstance.class);
        this.bind(new TypeLiteral<Function<RegionAndName, KeyPair>>(){}).to(CreateUniqueKeyPair.class);
        this.bind(new TypeLiteral<Function<RegionNameAndPublicKeyMaterial, KeyPair>>(){}).to(ImportOrReturnExistingKeypair.class);
        this.bind(new TypeLiteral<CacheLoader<RegionAndName, org.jclouds.compute.domain.Image>>(){}).to(RegionAndIdToImage.class);
        this.install(new FactoryModuleBuilder().build(CallForImages.Factory.class));
        this.bind(new TypeLiteral<Function<Image, org.jclouds.compute.domain.Image>>(){}).to(EC2ImageParser.class);
        this.bind(new TypeLiteral<ImageExtension>(){}).to(EC2ImageExtension.class);
        this.bind(new TypeLiteral<PredicateWithResult<String, org.jclouds.compute.domain.Image>>(){}).to(GetImageWhenStatusAvailablePredicateWithResult.class);
    }

    @Provides
    @Singleton
    @ImageQuery
    protected Map<String, String> imageQuery(ValueOfConfigurationKeyOrNull config) {
        String ccQuery;
        String amiQuery = Strings.emptyToNull(config.apply("jclouds.ec2.ami-query"));
        String owners = config.apply("jclouds.ec2.ami-owners");
        if ("".equals(owners)) {
            amiQuery = null;
        } else if (owners != null) {
            StringBuilder query = new StringBuilder();
            if ("*".equals(owners)) {
                query.append("state=available;image-type=machine");
            } else {
                query.append("owner-id=").append(owners).append(";state=available;image-type=machine");
            }
            Logger.getAnonymousLogger().warning(String.format("Property %s is deprecated, please use new syntax: %s=%s", "jclouds.ec2.ami-owners", "jclouds.ec2.ami-query", query.toString()));
            amiQuery = query.toString();
        }
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        if (amiQuery != null) {
            builder.put("jclouds.ec2.ami-query", amiQuery);
        }
        if ((ccQuery = Strings.emptyToNull(config.apply("jclouds.ec2.cc-ami-query"))) != null) {
            builder.put("jclouds.ec2.cc-ami-query", ccQuery);
        }
        return builder.build();
    }

    @Provides
    @Singleton
    @Named(value="AVAILABLE")
    protected Predicate<PlacementGroup> placementGroupAvailable(PlacementGroupAvailable available) {
        return new RetryablePredicate<PlacementGroup>(available, 60L, 1L, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Named(value="DELETED")
    protected Predicate<PlacementGroup> placementGroupDeleted(PlacementGroupDeleted deleted) {
        return new RetryablePredicate<PlacementGroup>(deleted, 60L, 1L, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Named(value="PLACEMENT")
    protected LoadingCache<RegionAndName, String> placementGroupMap(CreatePlacementGroupIfNeeded in) {
        return CacheBuilder.newBuilder().build(in);
    }

    @Provides
    @ClusterCompute
    @Singleton
    protected Set<String> provideClusterComputeIds() {
        return Sets.newLinkedHashSet();
    }
}

