/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore.config;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.jclouds.atmos.AtmosClient;
import org.jclouds.atmos.blobstore.AtmosAsyncBlobStore;
import org.jclouds.atmos.blobstore.AtmosBlobRequestSigner;
import org.jclouds.atmos.blobstore.AtmosBlobStore;
import org.jclouds.atmos.blobstore.strategy.FindMD5InUserMetadata;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.attr.ConsistencyModel;
import org.jclouds.blobstore.config.BlobStoreMapModule;
import org.jclouds.blobstore.strategy.ContainsValueInListStrategy;

public class AtmosBlobStoreContextModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.install(new BlobStoreMapModule());
        this.bind(ConsistencyModel.class).toInstance(ConsistencyModel.EVENTUAL);
        this.bind(AsyncBlobStore.class).to(AtmosAsyncBlobStore.class).in(Scopes.SINGLETON);
        this.bind(BlobStore.class).to(AtmosBlobStore.class).in(Scopes.SINGLETON);
        this.bind(ContainsValueInListStrategy.class).to(FindMD5InUserMetadata.class);
        this.bind(BlobRequestSigner.class).to(AtmosBlobRequestSigner.class);
    }

    @Provides
    @Singleton
    protected LoadingCache<String, Boolean> isPublic(final AtmosClient client) {
        return CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build(new CacheLoader<String, Boolean>(){

            public String toString() {
                return "isPublic()";
            }

            @Override
            public Boolean load(String arg0) throws Exception {
                return client.isPublic(arg0);
            }
        });
    }
}

