/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.process.manager.support;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.SortedMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.fusesource.process.manager.Installation;
import org.fusesource.process.manager.JarInstallParameters;
import org.fusesource.process.manager.ProcessController;
import org.fusesource.process.manager.ProcessManager;
import org.fusesource.process.manager.config.JsonHelper;
import org.fusesource.process.manager.config.ProcessConfig;
import org.fusesource.process.manager.support.DefaultProcessController;
import org.fusesource.process.manager.support.FileUtils;
import org.fusesource.process.manager.support.InstallScript;
import org.fusesource.process.manager.support.JarInstaller;
import org.fusesource.process.manager.support.command.CommandFailedException;
import org.fusesource.process.manager.support.command.Duration;

public class ProcessManagerImpl
implements ProcessManager {
    private Executor executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("fuse-process-manager-%s").build());
    private File storageLocation;
    private int lastId = 0;
    private final Duration untarTimeout = Duration.valueOf("1h");
    private SortedMap<Integer, Installation> installations = Maps.newTreeMap();

    public ProcessManagerImpl() {
    }

    public ProcessManagerImpl(File storageLocation) {
        this.storageLocation = storageLocation;
    }

    public void init() throws Exception {
        this.lastId = 0;
        File[] files = this.storageLocation.listFiles();
        if (files != null) {
            for (File file : files) {
                String name;
                if (!file.isDirectory() || !(name = file.getName()).matches("\\d+")) continue;
                try {
                    Integer value = Integer.parseInt(name);
                    if (value == null) continue;
                    int id = value;
                    if (id > this.lastId) {
                        this.lastId = id;
                    }
                    String url = "TODO";
                    ProcessConfig config = JsonHelper.loadProcessConfig(file);
                    this.createInstallation(id, this.findInstallDir(file), config);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
    }

    public String toString() {
        return "ProcessManager(" + this.storageLocation + ")";
    }

    public ImmutableList<Installation> listInstallations() {
        return ImmutableList.copyOf(this.installations.values());
    }

    @Override
    public ImmutableMap<Integer, Installation> listInstallationMap() {
        return ImmutableMap.copyOf(this.installations);
    }

    @Override
    public Installation install(final String url, URL controllerJson) throws Exception {
        InstallScript installScript = new InstallScript(){

            @Override
            public void doInstall(ProcessConfig config, int id, File installDir) throws Exception {
                config.setName(url);
                ProcessManagerImpl.this.untarTarball(url, installDir);
            }
        };
        return this.installViaScript(controllerJson, installScript);
    }

    @Override
    public Installation installJar(final JarInstallParameters parameters) throws Exception {
        InstallScript installScript = new InstallScript(){

            @Override
            public void doInstall(ProcessConfig config, int id, File installDir) throws Exception {
                String name = parameters.getGroupId() + ":" + parameters.getArtifactId();
                String version = parameters.getVersion();
                if (!Strings.isNullOrEmpty((String)version)) {
                    name = name + ":" + version;
                }
                config.setName(name);
                String resourceName = "process-launcher.tar.gz";
                final InputStream in = this.getClass().getClassLoader().getResourceAsStream(resourceName);
                Preconditions.checkNotNull((Object)in, (Object)("Could not find " + resourceName + " on the file system"));
                File tmpFile = File.createTempFile("process-launcher", ".tar.gz");
                Files.copy((InputSupplier)new InputSupplier<InputStream>(){

                    public InputStream getInput() throws IOException {
                        return in;
                    }
                }, (File)tmpFile);
                FileUtils.extractTar(tmpFile, installDir, ProcessManagerImpl.this.untarTimeout, ProcessManagerImpl.this.executor);
                File etc = new File(installDir, "etc");
                etc.mkdirs();
                Files.write((CharSequence)"", (File)new File(etc, "config.properties"), (Charset)Charsets.UTF_8);
                Files.write((CharSequence)"", (File)new File(etc, "jvm.config"), (Charset)Charsets.UTF_8);
                JarInstaller installer = new JarInstaller(ProcessManagerImpl.this.executor);
                installer.unpackJarProcess(config, id, installDir, parameters);
            }
        };
        return this.installViaScript(parameters.getControllerJson(), installScript);
    }

    public File getStorageLocation() {
        return this.storageLocation;
    }

    public void setStorageLocation(File storageLocation) {
        this.storageLocation = storageLocation;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    protected Installation installViaScript(URL controllerJson, InstallScript installScript) throws Exception {
        int id = this.createNextId();
        File installDir = this.createInstallDir(id);
        installDir.mkdirs();
        ProcessConfig config = this.loadControllerJson(controllerJson);
        installScript.doInstall(config, id, installDir);
        JsonHelper.saveProcessConfig(config, installDir);
        Installation installation = this.createInstallation(id, installDir, config);
        installation.getController().install();
        return installation;
    }

    protected void untarTarball(final String url, File installDir) throws IOException, CommandFailedException {
        File tarball = new File(installDir, "install.tar.gz");
        Files.copy((InputSupplier)new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                return new URL(url).openStream();
            }
        }, (File)tarball);
        FileUtils.extractTar(tarball, installDir, this.untarTimeout, this.executor);
    }

    protected ProcessConfig loadControllerJson(URL controllerJson) throws IOException {
        if (controllerJson == null) {
            return new ProcessConfig();
        }
        return JsonHelper.loadProcessConfig(controllerJson);
    }

    protected synchronized int createNextId() {
        File dir;
        do {
            ++this.lastId;
        } while ((dir = this.createInstallDir(this.lastId)).exists());
        return this.lastId;
    }

    protected File createInstallDir(int id) {
        return new File(this.storageLocation, "" + id);
    }

    protected Installation createInstallation(int id, File rootDir, ProcessConfig config) {
        File installDir = this.findInstallDir(rootDir);
        ProcessController controller = this.createController(id, config, rootDir, installDir);
        Installation installation = new Installation(id, installDir, controller, config);
        this.installations.put(id, installation);
        return installation;
    }

    protected ProcessController createController(int id, ProcessConfig config, File rootDir, File installDir) {
        return new DefaultProcessController(id, config, this.executor, installDir);
    }

    protected File findInstallDir(File rootDir) {
        if (this.installExists(rootDir)) {
            return rootDir;
        }
        File[] files = rootDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!this.installExists(file)) continue;
                return file;
            }
        }
        return rootDir;
    }

    protected boolean installExists(File file) {
        if (file.isDirectory()) {
            File binDir = new File(file, "bin");
            return binDir.exists() && binDir.isDirectory();
        }
        return false;
    }
}

