/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.utils;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.utils.InterpolationHelper;
import org.fusesource.fabric.zookeeper.utils.ZookeeperCommandBuilder;
import org.linkedin.zookeeper.client.ZKData;

public final class ZooKeeperRetriableUtils {
    private ZooKeeperRetriableUtils() {
    }

    public static void copy(IZKClient source, IZKClient dest, String path) throws InterruptedException, KeeperException {
        for (String child : ZookeeperCommandBuilder.getChildren(path).execute(source)) {
            child = path + "/" + child;
            if (ZooKeeperRetriableUtils.exists(dest, child) != null) continue;
            byte[] data = ZookeeperCommandBuilder.getData(child).execute(source);
            ZookeeperCommandBuilder.set(child, data).execute(dest);
            ZooKeeperRetriableUtils.copy(source, dest, child);
        }
    }

    public static void copy(IZKClient zk, String from, String to) throws InterruptedException, KeeperException {
        for (String child : ZookeeperCommandBuilder.getChildren(from).execute(zk)) {
            String fromChild = from + "/" + child;
            String toChild = to + "/" + child;
            if (ZooKeeperRetriableUtils.exists(zk, toChild) != null) continue;
            byte[] data = ZookeeperCommandBuilder.getData(fromChild).execute(zk);
            ZookeeperCommandBuilder.set(toChild, data).execute(zk);
            ZooKeeperRetriableUtils.copy(zk, fromChild, toChild);
        }
    }

    public static void add(IZKClient zooKeeper, String path, String value) throws InterruptedException, KeeperException {
        if (ZooKeeperRetriableUtils.exists(zooKeeper, path) == null) {
            ZookeeperCommandBuilder.set(path, value).execute(zooKeeper);
        } else {
            String data = ZookeeperCommandBuilder.getStringData(path).execute(zooKeeper);
            if (data == null) {
                data = "";
            }
            if (data.length() > 0) {
                data = data + " ";
            }
            data = data + value;
            ZookeeperCommandBuilder.set(path, data).execute(zooKeeper);
        }
    }

    public static void remove(IZKClient zooKeeper, String path, String value) throws InterruptedException, KeeperException {
        if (ZooKeeperRetriableUtils.exists(zooKeeper, path) != null) {
            AbstractList parts = new LinkedList();
            String data = zooKeeper.getStringData(path);
            if (data != null) {
                parts = new ArrayList<String>(Arrays.asList(data.split(" ")));
            }
            boolean changed = false;
            StringBuilder sb = new StringBuilder();
            Iterator it = parts.iterator();
            while (it.hasNext()) {
                String v = (String)it.next();
                if (!v.matches(value)) continue;
                it.remove();
                changed = true;
            }
            if (changed) {
                sb.delete(0, sb.length());
                for (String part : parts) {
                    if (data.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(part);
                }
                zooKeeper.setData(path, sb.toString());
            }
        }
    }

    public static String get(IZKClient zooKeeper, String path) throws InterruptedException, KeeperException {
        return ZookeeperCommandBuilder.getStringData(path).execute(zooKeeper);
    }

    public static void set(IZKClient zooKeeper, String path, String value) throws InterruptedException, KeeperException {
        ZookeeperCommandBuilder.set(path, value).execute(zooKeeper);
    }

    public static void set(IZKClient zooKeeper, String path, byte[] value) throws InterruptedException, KeeperException {
        if (ZooKeeperRetriableUtils.exists(zooKeeper, path) != null) {
            ZookeeperCommandBuilder.set(path, value).execute(zooKeeper);
        }
        try {
            ZookeeperCommandBuilder.set(path, value).execute(zooKeeper);
        }
        catch (KeeperException.NodeExistsException e) {
            ZookeeperCommandBuilder.set(path, value).execute(zooKeeper);
        }
    }

    public static void create(IZKClient zooKeeper, String path) throws InterruptedException, KeeperException {
        ZookeeperCommandBuilder.create(path).execute(zooKeeper);
    }

    public static void createDefault(IZKClient zooKeeper, String path, String value) throws InterruptedException, KeeperException {
        if (ZooKeeperRetriableUtils.exists(zooKeeper, path) == null) {
            ZookeeperCommandBuilder.set(path, value).execute(zooKeeper);
        }
    }

    public static Stat exists(IZKClient zooKeeper, String path) throws InterruptedException, KeeperException {
        return ZookeeperCommandBuilder.exists(path).execute(zooKeeper);
    }

    public static Properties getProperties(IZKClient zooKeeper, String path, Watcher watcher) throws InterruptedException, KeeperException {
        ZKData zkData = zooKeeper.getZKStringData(path, watcher);
        String value = (String)zkData.getData();
        Properties properties = new Properties();
        if (value != null) {
            try {
                properties.load(new StringReader(value));
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        return properties;
    }

    public static Properties getProperties(IZKClient zooKeeper, String path) throws InterruptedException, KeeperException {
        String value = ZookeeperCommandBuilder.getStringData(path).execute(zooKeeper);
        Properties properties = new Properties();
        if (value != null) {
            try {
                properties.load(new StringReader(value));
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        return properties;
    }

    public static void setProperties(IZKClient zooKeeper, String path, Properties properties) throws InterruptedException, KeeperException {
        StringWriter writer = new StringWriter();
        try {
            properties.store(writer, null);
            ZookeeperCommandBuilder.set(path, writer.toString()).execute(zooKeeper);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public static String getSubstitutedPath(IZKClient zooKeeper, String path) throws InterruptedException, KeeperException, IOException, URISyntaxException {
        byte[] data;
        String normalizedPath;
        String string = normalizedPath = path != null && path.contains("#") ? path.substring(0, path.lastIndexOf(35)) : path;
        if (normalizedPath != null && ZooKeeperRetriableUtils.exists(zooKeeper, normalizedPath) != null && (data = ZookeeperCommandBuilder.loadUrl(path).execute(zooKeeper)) != null && data.length > 0) {
            String str = new String(ZookeeperCommandBuilder.loadUrl(path).execute(zooKeeper), "UTF-8");
            return ZooKeeperRetriableUtils.getSubstitutedData(zooKeeper, str);
        }
        return null;
    }

    public static String getSubstitutedData(final IZKClient zooKeeper, String data) throws URISyntaxException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("data", data);
        InterpolationHelper.performSubstitution(props, new InterpolationHelper.SubstitutionCallback(){

            @Override
            public String getValue(String key) {
                if (key.startsWith("zk:")) {
                    try {
                        return new String(ZookeeperCommandBuilder.loadUrl(key).execute(zooKeeper), "UTF-8");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
        return (String)props.get("data");
    }

    public static String generatePassword() {
        StringBuilder password = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            long l = Math.round(Math.floor(Math.random() * 62.0));
            if (l < 10L) {
                password.append((char)(48L + l));
                continue;
            }
            if (l < 36L) {
                password.append((char)(65L + l - 10L));
                continue;
            }
            password.append((char)(97L + l - 36L));
        }
        return password.toString();
    }
}

