/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.maven.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServlet;
import org.apache.maven.repository.internal.DefaultServiceLocator;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.fusesource.fabric.maven.MavenProxy;
import org.fusesource.fabric.maven.impl.InvalidMavenArtifactRequest;
import org.fusesource.fabric.maven.impl.MavenProxyImpl;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.connector.wagon.WagonProvider;
import org.sonatype.aether.connector.wagon.WagonRepositoryConnectorFactory;
import org.sonatype.aether.installation.InstallRequest;
import org.sonatype.aether.installation.InstallResult;
import org.sonatype.aether.metadata.Metadata;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.RepositoryPolicy;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.MetadataRequest;
import org.sonatype.aether.resolution.MetadataResult;
import org.sonatype.aether.spi.connector.RepositoryConnectorFactory;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.metadata.DefaultMetadata;

public class MavenProxyServletSupport
extends HttpServlet
implements MavenProxy {
    protected static final Logger LOGGER = Logger.getLogger(MavenProxyServletSupport.class.getName());
    public static final Pattern ARTIFACT_REQUEST_URL_REGEX = Pattern.compile("([^ ]+)/([^/ ]+)/([^/ ]+)/([^/ ]+)");
    public static final Pattern ARTIFACT_METADATA_URL_REGEX = Pattern.compile("([^ ]+)/([^/ ]+)/([^/ ]+)/((maven-metadata([-]([^ .]+))?.xml))");
    public static final Pattern REPOSITORY_ID_REGEX = Pattern.compile("[^ ]*(@id=([^@ ]+))+[^ ]*");
    protected String localRepository;
    protected String remoteRepositories = "repo1.maven.org/maven2@id=central,repo.fusesource.com/nexus/content/groups/public@id=fusepublic,repo.fusesource.com/nexus/content/groups/releases@id=fusereleases,repo.fusesource.com/nexus/content/groups/public-snapshots@id=fusesnapshots,repo.fusesource.com/nexus/content/groups/ea@id=fuseeasrlyaccess";
    protected String updatePolicy;
    protected String checksumPolicy;
    protected Map<String, RemoteRepository> repositories;
    protected RepositorySystem system;
    protected RepositorySystemSession session;
    protected ConcurrentMap<String, Object> artifactLocks = new ConcurrentHashMap<String, Object>();
    protected File tmpFolder = new File(System.getProperty("karaf.data") + File.separator + "maven" + File.separator + "proxy" + File.separator + "tmp");

    @Override
    public synchronized void start() throws IOException {
        if (!this.tmpFolder.exists()) {
            this.tmpFolder.mkdirs();
        }
        if (this.localRepository.equals("")) {
            this.localRepository = System.getProperty("karaf.data") + File.separator + "maven" + File.separator + "proxy" + File.separator + "downloads";
        }
        if (this.system == null) {
            this.system = this.newRepositorySystem();
        }
        if (this.session == null) {
            this.session = this.newSession(this.system, this.localRepository);
        }
        this.repositories = new HashMap<String, RemoteRepository>();
        for (String rep : this.remoteRepositories.split(",")) {
            String id = "";
            RemoteRepository remoteRepository = null;
            Matcher idMatcher = REPOSITORY_ID_REGEX.matcher(rep = rep.trim());
            if (idMatcher.matches()) {
                id = idMatcher.group(2);
                rep = this.cleanUpRepositorySpec(rep);
                remoteRepository = new RemoteRepository(id + Math.abs(rep.hashCode()), "default", rep);
            } else {
                id = "rep-" + rep.hashCode();
                rep = this.cleanUpRepositorySpec(rep);
                remoteRepository = new RemoteRepository("repo-" + Math.abs(rep.hashCode()), "default", rep);
            }
            remoteRepository.setPolicy(true, new RepositoryPolicy(true, this.updatePolicy, this.checksumPolicy));
            this.repositories.put(id, remoteRepository);
        }
        this.repositories.put("local", new RemoteRepository("local", "default", "file://" + this.localRepository));
        this.repositories.put("karaf", new RemoteRepository("karaf", "default", "file://" + System.getProperty("karaf.home") + File.separator + System.getProperty("karaf.default.repository")));
        this.repositories.put("user", new RemoteRepository("user", "default", "file://" + System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository"));
    }

    @Override
    public synchronized void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File download(String path) throws InvalidMavenArtifactRequest {
        Matcher artifactMatcher = ARTIFACT_REQUEST_URL_REGEX.matcher(path);
        Matcher metdataMatcher = ARTIFACT_METADATA_URL_REGEX.matcher(path);
        if (path == null) {
            throw new InvalidMavenArtifactRequest();
        }
        if (metdataMatcher.matches()) {
            LOGGER.log(Level.INFO, String.format("Received request for maven metadata : %s", path));
            Metadata metadata = null;
            try {
                metadata = this.convertPathToMetadata(path);
                ArrayList<MetadataRequest> requests = new ArrayList<MetadataRequest>();
                String id = metdataMatcher.group(7);
                if (this.repositories.containsKey(id)) {
                    MetadataRequest request = new MetadataRequest(metadata, this.repositories.get(id), null);
                    request.setFavorLocalRepository(false);
                    requests.add(request);
                } else {
                    for (RemoteRepository repository : this.repositories.values()) {
                        MetadataRequest request = new MetadataRequest(metadata, repository, null);
                        request.setFavorLocalRepository(false);
                        requests.add(request);
                    }
                }
                List<MetadataResult> results = this.system.resolveMetadata(this.session, requests);
                for (MetadataResult result : results) {
                    if (result.getMetadata() == null || result.getMetadata().getFile() == null) continue;
                    return result.getMetadata().getFile();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, String.format("Could not find metadata : %s due to %s", metadata, e));
                return null;
            }
            return null;
        }
        if (artifactMatcher.matches()) {
            Object lock;
            LOGGER.log(Level.INFO, String.format("Received request for maven artifact : %s", path));
            Artifact artifact = this.convertPathToArtifact(path);
            String id = artifact.getGroupId() + ":" + artifact.getArtifactId();
            this.artifactLocks.putIfAbsent(id, new Object());
            Object v = lock = this.artifactLocks.get(id);
            synchronized (v) {
                try {
                    ArtifactRequest request = new ArtifactRequest(artifact, new ArrayList<RemoteRepository>(this.repositories.values()), null);
                    ArtifactResult result = this.system.resolveArtifact(this.session, request);
                    return result.getArtifact().getFile();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, String.format("Could not find artifact : %s due to %s", artifact, e));
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public boolean upload(InputStream is, String path) throws InvalidMavenArtifactRequest {
        boolean success = true;
        Matcher artifactMatcher = ARTIFACT_REQUEST_URL_REGEX.matcher(path);
        Matcher metdataMatcher = ARTIFACT_METADATA_URL_REGEX.matcher(path);
        if (path == null) {
            throw new InvalidMavenArtifactRequest();
        }
        if (metdataMatcher.matches()) {
            LOGGER.log(Level.INFO, String.format("Received upload request for maven metadata : %s", path));
            try {
                String filename = path.substring(path.lastIndexOf("/") + 1);
                Metadata metadata = this.convertPathToMetadata(path);
                metadata = metadata.setFile(this.readFile(is, this.tmpFolder, filename));
                InstallRequest request = new InstallRequest();
                request.addMetadata(metadata);
                InstallResult result = this.system.install(this.session, request);
                success = true;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, String.format("Failed to uploade metadata: %s due to %s", path, e));
                success = false;
            }
        } else if (artifactMatcher.matches()) {
            LOGGER.log(Level.INFO, String.format("Received upload request for maven artifact : %s", path));
            Artifact artifact = null;
            try {
                String filename = path.substring(path.lastIndexOf("/") + 1);
                artifact = this.convertPathToArtifact(path);
                artifact = artifact.setFile(this.readFile(is, this.tmpFolder, filename));
                InstallRequest request = new InstallRequest();
                request.addArtifact(artifact);
                InstallResult result = this.system.install(this.session, request);
                success = true;
                LOGGER.log(Level.INFO, "Artifact installed: " + artifact.toString());
            }
            catch (Exception e) {
                success = false;
                LOGGER.log(Level.WARNING, String.format("Failed to upload artifact : %s due to %s", artifact, e), e);
            }
        }
        return success;
    }

    protected RepositorySystemSession newSession(RepositorySystem system, String localRepository) {
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        LocalRepository localRepo = new LocalRepository(localRepository);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager(localRepo));
        return session;
    }

    protected RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = new DefaultServiceLocator();
        locator.setServices(WagonProvider.class, new MavenProxyImpl.ManualWagonProvider());
        locator.addService(RepositoryConnectorFactory.class, WagonRepositoryConnectorFactory.class);
        locator.setService(org.sonatype.aether.spi.log.Logger.class, LogAdapter.class);
        return locator.getService(RepositorySystem.class);
    }

    protected String convertToMavenUrl(String path) throws InvalidMavenArtifactRequest {
        String url = null;
        StringBuilder sb = new StringBuilder();
        if (path == null) {
            throw new InvalidMavenArtifactRequest("Cannot match request path to maven url, request path is empty.");
        }
        Matcher pathMatcher = ARTIFACT_REQUEST_URL_REGEX.matcher(path);
        if (pathMatcher.matches()) {
            String groupId = pathMatcher.group(1).replaceAll("/", ".");
            String artifactId = pathMatcher.group(2);
            String version = pathMatcher.group(3);
            String filename = pathMatcher.group(4);
            String extension = "jar";
            String classifier = "";
            String filePerfix = artifactId + "-" + version;
            String stripedFileName = filename.substring(filePerfix.length());
            if (version.endsWith("SNAPSHOT")) {
                stripedFileName = stripedFileName.replaceAll("\\d{8}.\\d+-\\d+", "SNAPSHOT");
            }
            if (stripedFileName != null && stripedFileName.startsWith("-") && stripedFileName.contains(".")) {
                classifier = stripedFileName.substring(1, stripedFileName.indexOf("."));
            }
            extension = stripedFileName.substring(stripedFileName.indexOf(".") + 1);
            sb.append(groupId).append(":").append(artifactId).append(":").append(extension).append(":");
            if (classifier != null && !classifier.isEmpty()) {
                sb.append(classifier).append(":");
            }
            sb.append(version);
            url = sb.toString();
        }
        return url;
    }

    protected Artifact convertPathToArtifact(String path) throws InvalidMavenArtifactRequest {
        return new DefaultArtifact(this.convertToMavenUrl(path), null);
    }

    protected Metadata convertPathToMetadata(String path) throws InvalidMavenArtifactRequest {
        DefaultMetadata metadata = null;
        StringBuilder sb = new StringBuilder();
        if (path == null) {
            throw new InvalidMavenArtifactRequest("Cannot match request path to maven url, request path is empty.");
        }
        Matcher pathMatcher = ARTIFACT_METADATA_URL_REGEX.matcher(path);
        if (pathMatcher.matches()) {
            String groupId = pathMatcher.group(1).replaceAll("/", ".");
            String artifactId = pathMatcher.group(2);
            String version = pathMatcher.group(3);
            metadata = new DefaultMetadata(groupId, artifactId, version, "", Metadata.Nature.RELEASE_OR_SNAPSHOT);
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File readFile(InputStream is, File tempLocation, String name) throws FileNotFoundException {
        File tmpFile = null;
        OutputStream fos = null;
        try {
            tmpFile = new File(tempLocation, name);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
            fos = new FileOutputStream(tmpFile);
            int length = 0;
            byte[] buffer = new byte[4096];
            while ((length = is.read(buffer)) != -1) {
                ((FileOutputStream)fos).write(buffer, 0, length);
            }
        }
        catch (Exception ex) {
        }
        finally {
            try {
                fos.flush();
            }
            catch (Exception ex) {}
            try {
                ((FileOutputStream)fos).close();
            }
            catch (Exception ex) {}
        }
        return tmpFile;
    }

    protected String cleanUpRepositorySpec(String spec) {
        if (spec == null || spec.isEmpty()) {
            return spec;
        }
        if (!spec.contains("@")) {
            return spec;
        }
        return spec.substring(0, spec.indexOf("@"));
    }

    public void setLocalRepository(String localRepository) {
        this.localRepository = localRepository;
    }

    public String getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public void setRemoteRepositories(String remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
    }

    public String getUpdatePolicy() {
        return this.updatePolicy;
    }

    public void setUpdatePolicy(String updatePolicy) {
        this.updatePolicy = updatePolicy;
    }

    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public void setChecksumPolicy(String checksumPolicy) {
        this.checksumPolicy = checksumPolicy;
    }

    public static class LogAdapter
    implements org.sonatype.aether.spi.log.Logger {
        @Override
        public boolean isDebugEnabled() {
            return LOGGER.isLoggable(Level.FINE);
        }

        @Override
        public void debug(String msg) {
            LOGGER.log(Level.FINE, msg);
        }

        @Override
        public void debug(String msg, Throwable error) {
            LOGGER.log(Level.FINE, msg, error);
        }

        @Override
        public boolean isWarnEnabled() {
            return LOGGER.isLoggable(Level.WARNING);
        }

        @Override
        public void warn(String msg) {
            LOGGER.log(Level.WARNING, msg);
        }

        @Override
        public void warn(String msg, Throwable error) {
            LOGGER.log(Level.WARNING, msg, error);
        }
    }
}

