/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util;

import org.apache.directory.shared.ldap.util.Position;
import org.apache.directory.shared.ldap.util.StringTools;

public class DNUtils {
    public static final int PARSING_ERROR = -1;
    public static final int PARSING_OK = 0;
    public static final int BAD_HEX_PAIR = -2;
    public static final int ONE_CHAR = 1;
    public static final int TWO_CHARS = 2;
    public static final int ONE_BYTE = 1;
    public static final int TWO_BYTES = 2;
    private static final boolean[] SAFE_INIT_CHAR = new boolean[]{false, true, true, true, true, true, true, true, true, true, false, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private static final boolean[] SAFE_CHAR = new boolean[]{false, true, true, true, true, true, true, true, true, true, false, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private static final boolean[] BASE64_CHAR = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, true, true, true, true, true, true, true, true, true, true, true, false, false, false, true, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    private static final boolean[] PAIR_CHAR = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, true, false, false, false, false, false, false, false, true, true, false, false, false, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static final boolean[] LUTF1 = new boolean[]{false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, false, false, true, true, true, true, true, true, true, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private static final boolean[] SUTF1 = new boolean[]{false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private static final boolean[] PAIR_CHAR_ONLY = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, true, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static final int[] STRING_CHAR = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 1, 1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 1, 1, 1, 1, 1, 1, 1, 1, -1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, -1, 1, -1, 1};
    public static final String OID_LOWER = "oid.";
    public static final String OID_UPPER = "OID.";

    public static int parseSafeString(byte[] bytes, int index) {
        if (bytes == null || bytes.length == 0 || index < 0 || index >= bytes.length) {
            return -1;
        }
        byte c = bytes[index];
        if ((c | 0x7F) != 127 || !SAFE_INIT_CHAR[c]) {
            return -1;
        }
        ++index;
        while (index < bytes.length && ((c = bytes[index]) | 0x7F) == 127 && SAFE_CHAR[c]) {
            ++index;
        }
        return index;
    }

    public static int parseAlphaASCII(byte[] bytes, int index) {
        byte b;
        if (bytes == null || bytes.length == 0 || index < 0 || index >= bytes.length) {
            return -1;
        }
        if (StringTools.isAlpha(b = bytes[index++])) {
            return index - 1;
        }
        return -1;
    }

    public static boolean isLUTF1(byte[] bytes, int index) {
        if (bytes == null || bytes.length == 0 || index < 0 || index >= bytes.length) {
            return false;
        }
        byte c = bytes[index];
        return (c | 0x7F) == 127 && LUTF1[c & 0x7F];
    }

    public static boolean isSUTF1(byte[] bytes, int index) {
        if (bytes == null || bytes.length == 0 || index < 0 || index >= bytes.length) {
            return false;
        }
        byte c = bytes[index];
        return (c | 0x7F) == 127 && SUTF1[c & 0x7F];
    }

    public static boolean isPairCharOnly(char c) {
        return (c | 0x7F) == 127 && PAIR_CHAR_ONLY[c & 0x7F];
    }

    public static boolean isPairChar(byte[] bytes, int index) {
        if (bytes == null || bytes.length == 0 || index < 0 || index >= bytes.length) {
            return false;
        }
        byte c = bytes[index];
        if ((c | 0x7F) != 127 || !PAIR_CHAR[c]) {
            return false;
        }
        if (PAIR_CHAR_ONLY[c]) {
            return true;
        }
        if (StringTools.isHex(bytes, index++)) {
            return StringTools.isHex(bytes, index);
        }
        return false;
    }

    public static int countPairChar(byte[] bytes, int index) {
        if (bytes == null) {
            return -1;
        }
        int length = bytes.length;
        if (length == 0 || index < 0 || index >= length) {
            return -1;
        }
        byte c = bytes[index];
        if ((c | 0x7F) != 127 || !PAIR_CHAR[c]) {
            return -1;
        }
        if (PAIR_CHAR_ONLY[c]) {
            return 1;
        }
        if (StringTools.isHex(bytes, index++)) {
            return StringTools.isHex(bytes, index) ? 2 : -1;
        }
        return -1;
    }

    public static int isStringChar(byte[] bytes, int index) {
        if (bytes == null || bytes.length == 0 || index < 0 || index >= bytes.length) {
            return -1;
        }
        byte c = bytes[index];
        if ((c | 0x3F) == 63) {
            return STRING_CHAR[c];
        }
        return StringTools.countBytesPerChar(bytes, index);
    }

    public static int isAciiStringChar(byte[] bytes, int index) {
        if (bytes == null || bytes.length == 0 || index < 0 || index >= bytes.length) {
            return -1;
        }
        byte c = bytes[index];
        if ((c | 0x3F) == 63) {
            return STRING_CHAR[c];
        }
        return StringTools.countBytesPerChar(bytes, index);
    }

    public static int isQuoteChar(byte[] bytes, int index) {
        if (bytes == null || bytes.length == 0 || index < 0 || index >= bytes.length) {
            return -1;
        }
        byte c = bytes[index];
        if (c == 92 || c == 34) {
            return -1;
        }
        return StringTools.countBytesPerChar(bytes, index);
    }

    public static int parseHexPair(byte[] bytes, int index) {
        if (StringTools.isHex(bytes, index)) {
            if (StringTools.isHex(bytes, index + 1)) {
                return index + 2;
            }
            return -2;
        }
        return -1;
    }

    private static byte getHexPair(byte[] bytes, int index) {
        return StringTools.getHexValue(bytes[index], bytes[index + 1]);
    }

    public static int parseHexString(byte[] bytes, int index) {
        int result = DNUtils.parseHexPair(bytes, index);
        if (result < 0) {
            return -1;
        }
        index += 2;
        while ((result = DNUtils.parseHexPair(bytes, index)) >= 0) {
            index += 2;
        }
        return result == -2 ? -1 : index;
    }

    public static int parseHexString(byte[] bytes, byte[] hex, Position pos) {
        int i = 0;
        pos.end = pos.start;
        int result = DNUtils.parseHexPair(bytes, pos.start);
        if (result < 0) {
            return -1;
        }
        hex[i++] = DNUtils.getHexPair(bytes, pos.end);
        pos.end += 2;
        while ((result = DNUtils.parseHexPair(bytes, pos.end)) >= 0) {
            hex[i++] = DNUtils.getHexPair(bytes, pos.end);
            pos.end += 2;
        }
        return result == -2 ? -1 : 0;
    }

    public static int parseBase64String(byte[] bytes, int index) {
        if (bytes == null || bytes.length == 0 || index < 0 || index >= bytes.length) {
            return -1;
        }
        byte c = bytes[index];
        if ((c | 0x7F) != 127 || !BASE64_CHAR[c]) {
            return -1;
        }
        ++index;
        while (index < bytes.length && ((c = bytes[index]) | 0x7F) == 127 && BASE64_CHAR[c]) {
            ++index;
        }
        return index;
    }
}

