/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.trigger;

import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapContext;
import org.apache.directory.shared.ldap.util.AttributeUtils;

public class TriggerUtils {
    public static final String ADMINISTRATIVE_ROLE_ATTR = "administrativeRole";
    public static final String TRIGGER_EXECUTION_SPECIFIC_AREA_ATTR_VALUE = "triggerExecutionSpecificArea";
    public static final String TRIGGER_EXECUTION_SUBENTRY_OC = "triggerExecutionSubentry";
    public static final String ENTRY_TRIGGER_SPECIFICATION_ATTR = "entryTriggerSpecification";
    public static final String PRESCRIPTIVE_TRIGGER_SPECIFICATION_ATTR = "prescriptiveTriggerSpecification";

    public static void defineTriggerExecutionSpecificPoint(LdapContext apCtx) throws NamingException {
        Attributes ap = apCtx.getAttributes("", new String[]{ADMINISTRATIVE_ROLE_ATTR});
        Attribute administrativeRole = ap.get(ADMINISTRATIVE_ROLE_ATTR);
        if (administrativeRole == null || !AttributeUtils.containsValueCaseIgnore(administrativeRole, TRIGGER_EXECUTION_SPECIFIC_AREA_ATTR_VALUE)) {
            BasicAttributes changes = new BasicAttributes(ADMINISTRATIVE_ROLE_ATTR, TRIGGER_EXECUTION_SPECIFIC_AREA_ATTR_VALUE, true);
            apCtx.modifyAttributes("", 1, (Attributes)changes);
        }
    }

    public static void createTriggerExecutionSubentry(LdapContext apCtx, String subentryCN, String subtreeSpec, String prescriptiveTriggerSpec) throws NamingException {
        BasicAttributes subentry = new BasicAttributes("cn", subentryCN, true);
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        subentry.put(objectClass);
        objectClass.add("top");
        objectClass.add("subentry");
        objectClass.add(TRIGGER_EXECUTION_SUBENTRY_OC);
        subentry.put("subtreeSpecification", subtreeSpec);
        subentry.put(PRESCRIPTIVE_TRIGGER_SPECIFICATION_ATTR, prescriptiveTriggerSpec);
        apCtx.createSubcontext("cn=" + subentryCN, (Attributes)subentry);
    }

    public static void loadPrescriptiveTriggerSpecification(LdapContext apCtx, String subentryCN, String triggerSpec) throws NamingException {
        BasicAttributes changes = new BasicAttributes(PRESCRIPTIVE_TRIGGER_SPECIFICATION_ATTR, triggerSpec, true);
        apCtx.modifyAttributes("cn=" + subentryCN, 1, (Attributes)changes);
    }

    public static void loadEntryTriggerSpecification(LdapContext ctx, String triggerSpec) throws NamingException {
        BasicAttributes changes = new BasicAttributes(ENTRY_TRIGGER_SPECIFICATION_ATTR, triggerSpec, true);
        ctx.modifyAttributes("", 1, (Attributes)changes);
    }
}

