/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntaxCheckers;

import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsnSidSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(CsnSidSyntaxChecker.class);
    private static final long serialVersionUID = 1L;

    public CsnSidSyntaxChecker() {
        super("1.3.6.1.4.1.4203.666.11.2.4");
    }

    public boolean isValidSyntax(Object value) {
        if (value == null) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        if (!(value instanceof String)) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        String sidStr = (String)value;
        if (sidStr.length() > 3) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        try {
            int sid = Integer.parseInt(sidStr, 16);
            if (sid < 0 || sid > 4095) {
                LOG.debug("Syntax invalid for '{}'", value);
                return false;
            }
        }
        catch (NumberFormatException nfe) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        LOG.debug("Syntax valid for '{}'", value);
        return true;
    }
}

