/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search.controls.persistentSearch;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.BooleanDecoder;
import org.apache.directory.shared.asn1.util.BooleanDecoderException;
import org.apache.directory.shared.asn1.util.IntegerDecoder;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.search.controls.persistentSearch.PersistentSearchControlContainer;
import org.apache.directory.shared.ldap.codec.search.controls.persistentSearch.PersistentSearchControlStatesEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentSearchControlGrammar
extends AbstractGrammar {
    static final Logger log = LoggerFactory.getLogger(PersistentSearchControlGrammar.class);
    static final boolean IS_DEBUG = log.isDebugEnabled();
    private static IGrammar instance = new PersistentSearchControlGrammar();

    private PersistentSearchControlGrammar() {
        this.name = PersistentSearchControlGrammar.class.getName();
        this.statesEnum = PersistentSearchControlStatesEnum.getInstance();
        this.transitions = new GrammarTransition[5][256];
        this.transitions[0][48] = new GrammarTransition(0, 1, 48, null);
        this.transitions[1][2] = new GrammarTransition(1, 2, 2, new GrammarAction("Set PSearchControl changeTypes"){

            public void action(IAsn1Container container) throws DecoderException {
                PersistentSearchControlContainer psearchContainer = (PersistentSearchControlContainer)container;
                Value value = psearchContainer.getCurrentTLV().getValue();
                try {
                    int changeTypes = IntegerDecoder.parse(value, 1, 15);
                    if (IS_DEBUG) {
                        log.debug("changeTypes = " + changeTypes);
                    }
                    psearchContainer.getPSearchControl().setChangeTypes(changeTypes);
                }
                catch (IntegerDecoderException e) {
                    String msg = I18n.err("ERR_04051", new Object[0]);
                    log.error(msg, (Throwable)e);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[2][1] = new GrammarTransition(2, 3, 1, new GrammarAction("Set PSearchControl changesOnly"){

            public void action(IAsn1Container container) throws DecoderException {
                PersistentSearchControlContainer psearchContainer = (PersistentSearchControlContainer)container;
                Value value = psearchContainer.getCurrentTLV().getValue();
                try {
                    boolean changesOnly = BooleanDecoder.parse(value);
                    if (IS_DEBUG) {
                        log.debug("changesOnly = " + changesOnly);
                    }
                    psearchContainer.getPSearchControl().setChangesOnly(changesOnly);
                }
                catch (BooleanDecoderException e) {
                    String msg = I18n.err("ERR_04052", new Object[0]);
                    log.error(msg, (Throwable)e);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[3][1] = new GrammarTransition(3, 4, 1, new GrammarAction("Set PSearchControl returnECs"){

            public void action(IAsn1Container container) throws DecoderException {
                PersistentSearchControlContainer psearchContainer = (PersistentSearchControlContainer)container;
                Value value = psearchContainer.getCurrentTLV().getValue();
                try {
                    boolean returnECs = BooleanDecoder.parse(value);
                    if (IS_DEBUG) {
                        log.debug("returnECs = " + returnECs);
                    }
                    psearchContainer.getPSearchControl().setReturnECs(returnECs);
                    psearchContainer.grammarEndAllowed(true);
                }
                catch (BooleanDecoderException e) {
                    String msg = I18n.err("ERR_04053", new Object[0]);
                    log.error(msg, (Throwable)e);
                    throw new DecoderException(msg);
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

