/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.search.SearchResultReferenceCodec;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreReferenceAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(StoreReferenceAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public StoreReferenceAction() {
        super("Store a reference");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        SearchResultReferenceCodec searchResultReference = ldapMessageContainer.getSearchResultReference();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        LdapURL url = LdapURL.EMPTY_URL;
        if (tlv.getLength() == 0) {
            searchResultReference.addSearchResultReference(url);
        } else {
            try {
                url = new LdapURL(tlv.getValue().getData());
                searchResultReference.addSearchResultReference(url);
            }
            catch (LdapURLEncodingException luee) {
                String badUrl = StringTools.utf8ToString(tlv.getValue().getData());
                log.error(I18n.err("ERR_04021", badUrl, luee.getMessage()));
                throw new DecoderException(I18n.err("ERR_04016", luee.getMessage()));
            }
        }
        if (IS_DEBUG) {
            log.debug("Search reference URL found : {}", (Object)url);
        }
        ldapMessageContainer.grammarEndAllowed(true);
    }
}

