/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.IntegerDecoder;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapResponseCodec;
import org.apache.directory.shared.ldap.codec.LdapResultCodec;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultCodeAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(ResultCodeAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public ResultCodeAction() {
        super("Store resultCode");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapResponseCodec response = ldapMessageContainer.getLdapResponse();
        LdapResultCodec ldapResult = new LdapResultCodec();
        response.setLdapResult(ldapResult);
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        Value value = tlv.getValue();
        ResultCodeEnum resultCode = ResultCodeEnum.SUCCESS;
        try {
            resultCode = ResultCodeEnum.getResultCode(IntegerDecoder.parse(value, 0, ResultCodeEnum.UNKNOWN.getResultCode()));
        }
        catch (IntegerDecoderException ide) {
            log.error(I18n.err("ERR_04018", StringTools.dumpBytes(value.getData()), ide.getMessage()));
            throw new DecoderException(ide.getMessage());
        }
        switch (resultCode) {
            case SUCCESS: 
            case OPERATIONS_ERROR: 
            case PROTOCOL_ERROR: 
            case TIME_LIMIT_EXCEEDED: 
            case SIZE_LIMIT_EXCEEDED: 
            case COMPARE_FALSE: 
            case COMPARE_TRUE: 
            case AUTH_METHOD_NOT_SUPPORTED: 
            case STRONG_AUTH_REQUIRED: 
            case REFERRAL: 
            case ADMIN_LIMIT_EXCEEDED: 
            case UNAVAILABLE_CRITICAL_EXTENSION: 
            case CONFIDENTIALITY_REQUIRED: 
            case SASL_BIND_IN_PROGRESS: 
            case NO_SUCH_ATTRIBUTE: 
            case UNDEFINED_ATTRIBUTE_TYPE: 
            case INAPPROPRIATE_MATCHING: 
            case CONSTRAINT_VIOLATION: 
            case ATTRIBUTE_OR_VALUE_EXISTS: 
            case INVALID_ATTRIBUTE_SYNTAX: 
            case NO_SUCH_OBJECT: 
            case ALIAS_PROBLEM: 
            case INVALID_DN_SYNTAX: 
            case ALIAS_DEREFERENCING_PROBLEM: 
            case INAPPROPRIATE_AUTHENTICATION: 
            case INVALID_CREDENTIALS: 
            case INSUFFICIENT_ACCESS_RIGHTS: 
            case BUSY: 
            case UNAVAILABLE: 
            case UNWILLING_TO_PERFORM: 
            case LOOP_DETECT: 
            case NAMING_VIOLATION: 
            case OBJECT_CLASS_VIOLATION: 
            case NOT_ALLOWED_ON_NON_LEAF: 
            case NOT_ALLOWED_ON_RDN: 
            case ENTRY_ALREADY_EXISTS: 
            case AFFECTS_MULTIPLE_DSAS: 
            case CANCELED: 
            case CANNOT_CANCEL: 
            case TOO_LATE: 
            case NO_SUCH_OPERATION: {
                ldapResult.setResultCode(resultCode);
                break;
            }
            default: {
                log.warn("The resultCode " + (Object)((Object)resultCode) + " is unknown.");
                ldapResult.setResultCode(ResultCodeEnum.OTHER);
            }
        }
        if (IS_DEBUG) {
            log.debug("The result code is set to " + (Object)((Object)resultCode));
        }
    }
}

