/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value.types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PaDataType {
    NULL(0),
    PA_TGS_REQ(1),
    PA_ENC_TIMESTAMP(2),
    PA_PW_SALT(3),
    PA_ENC_UNIX_TIME(5),
    PA_SANDIA_SECUREID(6),
    PA_SESAME(7),
    PA_OSF_DCE(8),
    PA_CYBERSAFE_SECUREID(9),
    PA_ASF3_SALT(10),
    PA_ENCTYPE_INFO(11),
    SAM_CHALLENGE(12),
    SAM_RESPONSE(13),
    PA_PK_AS_REQ(14),
    PA_PK_AS_REP(15),
    PA_USE_SPECIFIED_KVNO(20),
    SAM_REDIRECT(21),
    PA_GET_FROM_TYPED_DATA(22);

    private final int ordinal;

    private PaDataType(int ordinal) {
        this.ordinal = ordinal;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public static PaDataType getTypeByOrdinal(int type) {
        switch (type) {
            case 1: {
                return PA_TGS_REQ;
            }
            case 2: {
                return PA_ENC_TIMESTAMP;
            }
            case 3: {
                return PA_PW_SALT;
            }
            case 5: {
                return PA_ENC_UNIX_TIME;
            }
            case 6: {
                return PA_SANDIA_SECUREID;
            }
            case 7: {
                return PA_SESAME;
            }
            case 8: {
                return PA_OSF_DCE;
            }
            case 9: {
                return PA_CYBERSAFE_SECUREID;
            }
            case 10: {
                return PA_ASF3_SALT;
            }
            case 11: {
                return PA_ENCTYPE_INFO;
            }
            case 12: {
                return SAM_CHALLENGE;
            }
            case 13: {
                return SAM_RESPONSE;
            }
            case 14: {
                return PA_PK_AS_REQ;
            }
            case 15: {
                return PA_PK_AS_REQ;
            }
            case 20: {
                return PA_USE_SPECIFIED_KVNO;
            }
            case 21: {
                return SAM_REDIRECT;
            }
            case 22: {
                return PA_GET_FROM_TYPED_DATA;
            }
        }
        return NULL;
    }

    public String toString() {
        switch (this) {
            case PA_TGS_REQ: {
                return "TGS request.(" + this.ordinal + ")";
            }
            case PA_ENC_TIMESTAMP: {
                return "Encrypted timestamp.(" + this.ordinal + ")";
            }
            case PA_PW_SALT: {
                return "password salt(" + this.ordinal + ")";
            }
            case PA_ENC_UNIX_TIME: {
                return "enc unix time(" + this.ordinal + ")";
            }
            case PA_SANDIA_SECUREID: {
                return "sandia secureid(" + this.ordinal + ")";
            }
            case PA_SESAME: {
                return "sesame(" + this.ordinal + ")";
            }
            case PA_OSF_DCE: {
                return "OSF DCE(" + this.ordinal + ")";
            }
            case PA_CYBERSAFE_SECUREID: {
                return "cybersafe secureid(" + this.ordinal + ")";
            }
            case PA_ASF3_SALT: {
                return "ASF3 salt(" + this.ordinal + ")";
            }
            case PA_ENCTYPE_INFO: {
                return "Encryption info.(" + this.ordinal + ")";
            }
            case SAM_CHALLENGE: {
                return "SAM challenge.(" + this.ordinal + ")";
            }
            case SAM_RESPONSE: {
                return "SAM response.(" + this.ordinal + ")";
            }
            case PA_PK_AS_REQ: {
                return "PK as request(" + this.ordinal + ")";
            }
            case PA_PK_AS_REP: {
                return "PK as response(" + this.ordinal + ")";
            }
            case PA_USE_SPECIFIED_KVNO: {
                return "use specified key version(" + this.ordinal + ")";
            }
            case SAM_REDIRECT: {
                return "SAM redirect.(" + this.ordinal + ")";
            }
            case PA_GET_FROM_TYPED_DATA: {
                return "Get from typed data(" + this.ordinal + ")";
            }
        }
        return "null(" + this.ordinal + ")";
    }
}

