/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.shared.messages.value.types.TransitedEncodingType;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitedEncoding
extends AbstractAsn1Object {
    private static final Logger log = LoggerFactory.getLogger(TransitedEncoding.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private TransitedEncodingType trType;
    private byte[] contents;
    private transient int trTypeLength;
    private transient int contentsLength;
    private transient int transitedEncodingLength;

    public TransitedEncoding() {
        this.trType = TransitedEncodingType.NULL;
        this.contents = new byte[0];
    }

    public TransitedEncoding(TransitedEncodingType trType, byte[] contents) {
        this.trType = trType;
        this.contents = contents;
    }

    public byte[] getContents() {
        return this.contents;
    }

    public void setContents(byte[] contents) {
        this.contents = contents;
    }

    public TransitedEncodingType getTrType() {
        return this.trType;
    }

    public void setTrType(TransitedEncodingType trType) {
        this.trType = trType;
    }

    public int computeLength() {
        this.trTypeLength = 2 + Value.getNbBytes(this.trType.getOrdinal());
        this.transitedEncodingLength = 1 + TLV.getNbBytes(this.trTypeLength) + this.trTypeLength;
        this.contentsLength = this.contents == null ? 2 : 1 + TLV.getNbBytes(this.contents.length) + this.contents.length;
        this.transitedEncodingLength += 1 + TLV.getNbBytes(this.contentsLength) + this.contentsLength;
        int transitedEncodingSeqLength = 1 + Value.getNbBytes(this.transitedEncodingLength) + this.transitedEncodingLength;
        return transitedEncodingSeqLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_148, new Object[0]));
        }
        try {
            buffer.put((byte)48);
            buffer.put(TLV.getBytes(this.transitedEncodingLength));
            buffer.put((byte)-96);
            buffer.put(TLV.getBytes(this.trTypeLength));
            Value.encode(buffer, this.trType.getOrdinal());
            buffer.put((byte)-95);
            buffer.put(TLV.getBytes(this.contentsLength));
            Value.encode(buffer, this.contents);
        }
        catch (BufferOverflowException boe) {
            log.error(I18n.err(I18n.ERR_147, 1 + TLV.getNbBytes(this.transitedEncodingLength) + this.transitedEncodingLength, buffer.capacity()));
            throw new EncoderException(I18n.err(I18n.ERR_138, new Object[0]));
        }
        if (IS_DEBUG) {
            log.debug("TransitedEncoding encoding : {}", (Object)StringTools.dumpBytes(buffer.array()));
            log.debug("TransitedEncoding initial value : {}", (Object)this.toString());
        }
        return buffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TransitedEncoding : {\n");
        sb.append("    tr-type: ").append((Object)this.trType).append('\n');
        sb.append("    contents: ").append(StringTools.dumpBytes(this.contents)).append("\n}\n");
        return sb.toString();
    }
}

