/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.directory.server.kerberos.shared.io.encoder.EncryptedDataEncoder;
import org.apache.directory.server.kerberos.shared.messages.application.ApplicationReply;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class ApplicationReplyEncoder {
    public static final int APPLICATION_CODE = 15;

    public byte[] encode(ApplicationReply reply) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream(baos);
        DERSequence replySequence = this.encodeReplySequence(reply);
        aos.writeObject(DERApplicationSpecific.valueOf(15, replySequence));
        aos.close();
        return baos.toByteArray();
    }

    private DERSequence encodeReplySequence(ApplicationReply message) {
        DERSequence sequence = new DERSequence();
        sequence.add(new DERTaggedObject(0, DERInteger.valueOf(message.getProtocolVersionNumber())));
        sequence.add(new DERTaggedObject(1, DERInteger.valueOf(message.getMessageType().getOrdinal())));
        sequence.add(new DERTaggedObject(2, EncryptedDataEncoder.encodeSequence(message.getEncPart())));
        return sequence;
    }
}

