/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dhcp.messages;

import java.net.InetAddress;
import org.apache.directory.server.dhcp.messages.HardwareAddress;
import org.apache.directory.server.dhcp.messages.MessageType;
import org.apache.directory.server.dhcp.options.OptionsField;

public class DhcpMessage {
    public static final int FLAG_BROADCAST = 1;
    private InetAddress assignedClientAddress;
    private String bootFileName;
    private InetAddress currentClientAddress;
    private short flags;
    private short hopCount;
    private byte op;
    public static final byte OP_BOOTREQUEST = 1;
    public static final byte OP_BOOTREPLY = 2;
    private InetAddress nextServerAddress;
    private OptionsField options = new OptionsField();
    private InetAddress relayAgentAddress;
    private int seconds;
    private String serverHostname;
    private int transactionId;
    private MessageType messageType;
    private HardwareAddress hardwareAddress;

    public DhcpMessage() {
    }

    public DhcpMessage(MessageType messageType, byte op, HardwareAddress hardwareAddress, short hops, int transactionId, int seconds, short flags, InetAddress currentClientAddress, InetAddress assignedClientAddress, InetAddress nextServerAddress, InetAddress relayAgentAddress, String serverHostname, String bootFileName, OptionsField options) {
        this.messageType = messageType;
        this.op = op;
        this.hardwareAddress = hardwareAddress;
        this.hopCount = hops;
        this.transactionId = transactionId;
        this.seconds = seconds;
        this.flags = flags;
        this.currentClientAddress = currentClientAddress;
        this.assignedClientAddress = assignedClientAddress;
        this.nextServerAddress = nextServerAddress;
        this.relayAgentAddress = relayAgentAddress;
        this.serverHostname = serverHostname;
        this.bootFileName = bootFileName;
        this.options = options;
    }

    public InetAddress getAssignedClientAddress() {
        return this.assignedClientAddress;
    }

    public String getBootFileName() {
        return this.bootFileName;
    }

    public InetAddress getCurrentClientAddress() {
        return this.currentClientAddress;
    }

    public short getFlags() {
        return this.flags;
    }

    public short getHopCount() {
        return this.hopCount;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public InetAddress getNextServerAddress() {
        return this.nextServerAddress;
    }

    public OptionsField getOptions() {
        return this.options;
    }

    public InetAddress getRelayAgentAddress() {
        return this.relayAgentAddress;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public String getServerHostname() {
        return this.serverHostname;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public void setAssignedClientAddress(InetAddress assignedClientAddress) {
        this.assignedClientAddress = assignedClientAddress;
    }

    public void setBootFileName(String bootFileName) {
        this.bootFileName = bootFileName;
    }

    public void setCurrentClientAddress(InetAddress currentClientAddress) {
        this.currentClientAddress = currentClientAddress;
    }

    public void setFlags(short flags) {
        this.flags = flags;
    }

    public void setHopCount(short hopCount) {
        this.hopCount = hopCount;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public void setNextServerAddress(InetAddress nextServerAddress) {
        this.nextServerAddress = nextServerAddress;
    }

    public void setOptions(OptionsField options) {
        this.options = options;
    }

    public void setRelayAgentAddress(InetAddress relayAgentAddress) {
        this.relayAgentAddress = relayAgentAddress;
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    public void setServerHostname(String serverHostname) {
        this.serverHostname = serverHostname;
    }

    public void setTransactionId(int transactionId) {
        this.transactionId = transactionId;
    }

    public byte getOp() {
        return this.op;
    }

    public void setOp(byte op) {
        this.op = op;
    }

    public HardwareAddress getHardwareAddress() {
        return this.hardwareAddress;
    }

    public void setHardwareAddress(HardwareAddress hardwareAddress) {
        this.hardwareAddress = hardwareAddress;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.messageType).append(": hwAddress=").append(this.hardwareAddress).append(", tx=").append(this.transactionId).append(", options=").append(this.options);
        return sb.toString();
    }
}

