/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree;

import org.apache.directory.server.core.avltree.AvlTree;
import org.apache.directory.server.core.avltree.LinkedAvlNode;
import org.apache.directory.shared.ldap.cursor.AbstractCursor;
import org.apache.directory.shared.ldap.cursor.InvalidCursorPositionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvlTreeCursor<K>
extends AbstractCursor<K> {
    private AvlTree<K> tree;
    private LinkedAvlNode<K> node;
    private boolean onNode = false;
    private boolean isAfterLast = false;
    private boolean isBeforeFirst = true;

    public AvlTreeCursor(AvlTree<K> tree) {
        this.tree = tree;
    }

    @Override
    public void after(K element) throws Exception {
        this.checkNotClosed("after");
        if (element == null) {
            this.afterLast();
            return;
        }
        LinkedAvlNode<K> found = this.tree.findGreater(element);
        if (found == null) {
            this.node = this.tree.getLast();
            this.onNode = false;
            this.isAfterLast = true;
            this.isBeforeFirst = false;
            return;
        }
        this.node = found;
        this.isAfterLast = false;
        this.isBeforeFirst = false;
        this.onNode = false;
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast");
        this.node = this.tree.getLast();
        this.isBeforeFirst = false;
        this.isAfterLast = true;
        this.onNode = false;
    }

    @Override
    public boolean available() {
        return this.onNode;
    }

    @Override
    public void before(K element) throws Exception {
        this.checkNotClosed("before");
        if (element == null) {
            this.beforeFirst();
            return;
        }
        LinkedAvlNode<K> found = this.tree.findLess(element);
        if (found == null) {
            this.node = this.tree.getFirst();
            this.isAfterLast = false;
            this.isBeforeFirst = true;
        } else {
            this.node = found.next;
            this.isAfterLast = false;
            this.isBeforeFirst = false;
        }
        this.onNode = false;
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst");
        this.node = this.tree.getFirst();
        this.isBeforeFirst = true;
        this.isAfterLast = false;
        this.onNode = false;
    }

    @Override
    public boolean first() throws Exception {
        this.checkNotClosed("first");
        this.node = this.tree.getFirst();
        this.isBeforeFirst = false;
        this.isAfterLast = false;
        this.onNode = this.node != null;
        return this.onNode;
    }

    @Override
    public K get() throws Exception {
        this.checkNotClosed("get");
        if (this.onNode) {
            return this.node.getKey();
        }
        throw new InvalidCursorPositionException();
    }

    @Override
    public boolean isElementReused() {
        return true;
    }

    @Override
    public boolean last() throws Exception {
        this.checkNotClosed("last");
        this.node = this.tree.getLast();
        this.isBeforeFirst = false;
        this.isAfterLast = false;
        this.onNode = this.node != null;
        return this.onNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("next");
        if (this.isBeforeFirst) {
            this.node = this.tree.getFirst();
            this.isBeforeFirst = false;
            this.isAfterLast = false;
            this.onNode = this.node != null;
            return this.onNode;
        }
        if (this.isAfterLast) {
            return false;
        }
        if (this.onNode) {
            if (this.node == null) {
                this.node = this.tree.getFirst();
                return true;
            }
            if (this.node.next == null) {
                this.onNode = false;
                this.isAfterLast = true;
                this.isBeforeFirst = false;
                return false;
            }
            this.node = this.node.next;
            return true;
        }
        if (this.node == null) return false;
        this.onNode = true;
        if (!true) return false;
        return true;
    }

    @Override
    public boolean previous() throws Exception {
        this.checkNotClosed("previous");
        if (this.isBeforeFirst) {
            return false;
        }
        if (this.isAfterLast) {
            this.node = this.tree.getLast();
            this.isBeforeFirst = false;
            this.isAfterLast = false;
            this.onNode = this.node != null;
            return this.onNode;
        }
        if (this.onNode) {
            if (this.node == null) {
                this.node = this.tree.getLast();
                return true;
            }
            if (this.node.previous == null) {
                this.onNode = false;
                this.isAfterLast = false;
                this.isBeforeFirst = true;
                return false;
            }
            this.node = this.node.previous;
            return true;
        }
        return false;
    }
}

