/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.Collection;
import java.util.Iterator;
import javax.naming.NamingException;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.MicroOperation;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighestPrecedenceFilter
implements ACITupleFilter {
    @Override
    public Collection<ACITuple> filter(SchemaManager schemaManager, Collection<ACITuple> tuples, OperationScope scope, OperationContext opContext, Collection<DN> userGroupNames, DN userName, ServerEntry userEntry, AuthenticationLevel authenticationLevel, DN entryName, String attrId, Value<?> attrValue, ServerEntry entry, Collection<MicroOperation> microOperations, ServerEntry entryView) throws NamingException {
        if (tuples.size() <= 1) {
            return tuples;
        }
        int maxPrecedence = -1;
        for (ACITuple tuple : tuples) {
            if (tuple.getPrecedence() <= maxPrecedence) continue;
            maxPrecedence = tuple.getPrecedence();
        }
        Iterator<ACITuple> i = tuples.iterator();
        while (i.hasNext()) {
            ACITuple tuple;
            tuple = i.next();
            if (tuple.getPrecedence() == maxPrecedence) continue;
            i.remove();
        }
        return tuples;
    }
}

