/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.normalizers;

import org.apache.directory.shared.ldap.entry.StringValue;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.schema.Normalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectIdentifierNormalizer
extends Normalizer {
    public static final long serialVersionUID = 1L;

    public ObjectIdentifierNormalizer() {
        super("2.5.13.0");
    }

    @Override
    public Value<?> normalize(Value<?> value) throws LdapException {
        if (value == null) {
            return null;
        }
        String str = value.getString().trim();
        if (str.length() == 0) {
            return new StringValue("");
        }
        if (Character.isDigit(str.charAt(0))) {
            return new StringValue(str);
        }
        return new StringValue(str.toLowerCase());
    }

    @Override
    public String normalize(String value) throws LdapException {
        if (value == null) {
            return null;
        }
        String str = value.trim();
        if (str.length() == 0) {
            return "";
        }
        if (Character.isDigit(str.charAt(0))) {
            return str;
        }
        return str.toLowerCase();
    }
}

