/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.entry.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.entry.AbstractValue;
import org.apache.directory.shared.ldap.entry.BinaryValue;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.StringValue;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClientAttribute
implements EntryAttribute {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultClientAttribute.class);
    protected AttributeType attributeType;
    protected Set<Value<?>> values = new LinkedHashSet();
    protected String upId;
    protected String id;
    protected Boolean isHR;

    public DefaultClientAttribute() {
    }

    public DefaultClientAttribute(String upId) {
        this.setUpId(upId);
    }

    public DefaultClientAttribute(String upId, Value<?> ... vals) {
        if (vals[0] == null) {
            this.add(new StringValue());
        } else {
            for (Value<?> val : vals) {
                if (!(val instanceof StringValue) && !val.isBinary()) {
                    String message = I18n.err("ERR_04129", val.getClass().getName());
                    LOG.error(message);
                    throw new IllegalStateException(message);
                }
                this.add(val);
            }
        }
        this.setUpId(upId);
    }

    public DefaultClientAttribute(String upId, String ... vals) {
        this.add(vals);
        this.setUpId(upId);
    }

    public DefaultClientAttribute(String upId, byte[] ... vals) {
        this.add(vals);
        this.setUpId(upId);
    }

    @Override
    public byte[] getBytes() throws LdapInvalidAttributeValueException {
        Value<?> value = this.get();
        if (value.isBinary()) {
            return value.getBytes();
        }
        String message = I18n.err("ERR_04130", new Object[0]);
        LOG.error(message);
        throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, message);
    }

    @Override
    public String getString() throws LdapInvalidAttributeValueException {
        Value<?> value = this.get();
        if (value instanceof StringValue) {
            return value.getString();
        }
        String message = I18n.err("ERR_04131", new Object[0]);
        LOG.error(message);
        throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, message);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setHR(boolean isHR) {
        this.isHR = isHR;
    }

    @Override
    public void setId(String id) {
        this.id = StringTools.trim(StringTools.lowerCaseAscii(id));
        if (this.id.length() == 0) {
            this.id = null;
            throw new IllegalArgumentException(I18n.err("ERR_04132", new Object[0]));
        }
    }

    @Override
    public String getUpId() {
        return this.upId;
    }

    @Override
    public void setUpId(String upId) {
        this.setUpId(upId, null);
    }

    private boolean areCompatible(String id, AttributeType attributeType) {
        int optPos = id.indexOf(";");
        String idNoOption = id;
        if (optPos != -1) {
            idNoOption = id.substring(0, optPos);
        }
        for (String name : attributeType.getNames()) {
            if (!name.equalsIgnoreCase(idNoOption)) continue;
            return true;
        }
        return OID.isOID(id) && attributeType.getOid().equals(id);
    }

    @Override
    public void setUpId(String upId, AttributeType attributeType) {
        String trimmed = StringTools.trim(upId);
        if (StringTools.isEmpty(trimmed) && attributeType == null) {
            throw new IllegalArgumentException("Cannot set a null ID with a null AttributeType");
        }
        String id = StringTools.toLowerCase(trimmed);
        if (attributeType == null) {
            if (this.attributeType == null) {
                this.upId = upId;
                this.id = id;
                return;
            }
            if (this.areCompatible(id, this.attributeType)) {
                this.upId = upId;
                this.id = id;
                return;
            }
            return;
        }
        if (StringTools.isEmpty(id)) {
            this.attributeType = attributeType;
            this.upId = attributeType.getName();
            this.id = StringTools.trim(this.upId);
            return;
        }
        if (this.areCompatible(id, attributeType)) {
            this.upId = upId;
            this.id = id;
            this.attributeType = attributeType;
            return;
        }
        throw new IllegalArgumentException("ID '" + id + "' and AttributeType '" + attributeType.getName() + "' are not compatible ");
    }

    @Override
    public boolean isHR() {
        return this.isHR != null ? this.isHR : false;
    }

    @Override
    public boolean isValid() throws LdapException {
        for (Value<?> value : this.values) {
            if (value.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValid(SyntaxChecker checker) throws LdapException {
        for (Value<?> value : this.values) {
            if (value.isValid(checker)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int add(Value<?> ... vals) {
        int nbAdded = 0;
        BinaryValue nullBinaryValue = null;
        StringValue nullStringValue = null;
        boolean nullValueAdded = false;
        for (Value<?> val : vals) {
            if (val == null) {
                if (this.isHR == null) {
                    nullBinaryValue = new BinaryValue((byte[])null);
                    nullStringValue = new StringValue((String)null);
                    this.values.add(nullBinaryValue);
                    this.values.add(nullStringValue);
                    nullValueAdded = true;
                    ++nbAdded;
                    continue;
                }
                if (!this.isHR.booleanValue()) {
                    nullBinaryValue = new BinaryValue((byte[])null);
                    if (this.values.contains(nullBinaryValue)) continue;
                    this.values.add(nullBinaryValue);
                    ++nbAdded;
                    continue;
                }
                nullStringValue = new StringValue((String)null);
                if (this.values.contains(nullStringValue)) continue;
                this.values.add(nullStringValue);
                continue;
            }
            if (val instanceof StringValue) {
                if (this.isHR == null) {
                    this.isHR = true;
                    this.values.add(val);
                    ++nbAdded;
                    continue;
                }
                if (!this.isHR.booleanValue()) {
                    BinaryValue bv = new BinaryValue(val.getBytes());
                    if (this.contains(bv)) continue;
                    this.values.add(bv);
                    ++nbAdded;
                    continue;
                }
                if (this.contains(val)) continue;
                this.values.add(val);
                ++nbAdded;
                continue;
            }
            if (this.isHR == null) {
                this.isHR = false;
                this.values.add(val);
                ++nbAdded;
                continue;
            }
            if (!this.isHR.booleanValue()) {
                if (this.contains(val)) continue;
                this.values.add(val);
                ++nbAdded;
                continue;
            }
            StringValue sv = new StringValue(val.getString());
            if (this.contains(sv)) continue;
            this.values.add(sv);
            ++nbAdded;
        }
        if (nullValueAdded) {
            if (this.isHR.booleanValue()) {
                this.values.remove(nullBinaryValue);
            } else {
                this.values.remove(nullStringValue);
            }
        }
        return nbAdded;
    }

    @Override
    public int add(String ... vals) {
        int nbAdded = 0;
        if (this.isHR == null) {
            this.isHR = true;
        }
        if (this.isHR.booleanValue()) {
            for (String val : vals) {
                if (this.contains(val) || this.add(new StringValue(val)) != 1) continue;
                ++nbAdded;
            }
        } else {
            for (String val : vals) {
                byte[] valBytes = null;
                if (val != null) {
                    valBytes = StringTools.getBytesUtf8(val);
                }
                if (this.add(new BinaryValue(valBytes)) != 1) continue;
                ++nbAdded;
            }
        }
        return nbAdded;
    }

    @Override
    public int add(byte[] ... vals) {
        int nbAdded = 0;
        if (this.isHR == null) {
            this.isHR = false;
        }
        if (this.isHR.booleanValue()) {
            for (byte[] val : vals) {
                String valString = null;
                if (val != null) {
                    valString = StringTools.utf8ToString(val);
                }
                if (this.contains(new byte[][]{val}) || this.add(new StringValue(valString)) != 1) continue;
                ++nbAdded;
            }
        } else {
            for (byte[] val : vals) {
                if (this.add(new BinaryValue(val)) != 1) continue;
                ++nbAdded;
            }
        }
        return nbAdded;
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public boolean contains(Value<?> ... vals) {
        if (this.isHR == null) {
            return false;
        }
        if (this.isHR.booleanValue()) {
            for (Value<?> val : vals) {
                byte[] binaryVal;
                if (!(val instanceof StringValue ? !this.values.contains(val) : !this.values.contains(new StringValue(StringTools.utf8ToString(binaryVal = val.getBytes()))))) continue;
                return false;
            }
        } else {
            for (Value<?> val : vals) {
                String stringVal;
                if (!(val.isBinary() ? !this.values.contains(val) : !this.values.contains(new BinaryValue(StringTools.getBytesUtf8(stringVal = val.getString()))))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean contains(String ... vals) {
        if (this.isHR == null) {
            return false;
        }
        if (this.isHR.booleanValue()) {
            for (String val : vals) {
                if (this.contains(new StringValue(val))) continue;
                return false;
            }
        } else {
            for (String val : vals) {
                byte[] binaryVal = StringTools.getBytesUtf8(val);
                if (this.contains(new BinaryValue(binaryVal))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean contains(byte[] ... vals) {
        if (this.isHR == null) {
            return false;
        }
        if (!this.isHR.booleanValue()) {
            for (byte[] val : vals) {
                if (this.contains(new BinaryValue(val))) continue;
                return false;
            }
        } else {
            for (byte[] val : vals) {
                String stringVal = StringTools.utf8ToString(val);
                if (this.contains(new StringValue(stringVal))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean contains(Object ... vals) {
        boolean isHR = true;
        boolean seen = false;
        for (Object val : vals) {
            if (val instanceof String) {
                if (!seen) {
                    isHR = true;
                    seen = true;
                }
                if (isHR) {
                    if (this.contains((String)val)) continue;
                    return false;
                }
                return false;
            }
            if (!seen) {
                isHR = false;
                seen = true;
            }
            if (!isHR) {
                if (this.contains(new byte[][]{(byte[])val})) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public Value<?> get() {
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.iterator().next();
    }

    @Override
    public Value<?> get(int i) {
        if (this.values.size() < i) {
            return null;
        }
        int n = 0;
        for (Value<?> value : this.values) {
            if (n == i) {
                return value;
            }
            ++n;
        }
        return null;
    }

    @Override
    public Iterator<Value<?>> getAll() {
        return this.iterator();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean remove(Value<?> ... vals) {
        if (this.isHR == null || this.values.size() == 0) {
            return false;
        }
        boolean removed = true;
        if (this.isHR.booleanValue()) {
            for (Value<?> val : vals) {
                if (val instanceof StringValue) {
                    removed &= this.values.remove(val);
                    continue;
                }
                byte[] binaryVal = val.getBytes();
                removed &= this.values.remove(new StringValue(StringTools.utf8ToString(binaryVal)));
            }
        } else {
            for (Value<?> val : vals) {
                removed &= this.values.remove(val);
            }
        }
        return removed;
    }

    @Override
    public boolean remove(byte[] ... vals) {
        if (this.isHR == null || this.values.size() == 0) {
            return false;
        }
        boolean removed = true;
        if (!this.isHR.booleanValue()) {
            for (byte[] val : vals) {
                BinaryValue value = new BinaryValue(val);
                removed &= this.values.remove(value);
            }
        } else {
            for (byte[] val : vals) {
                StringValue value = new StringValue(StringTools.utf8ToString(val));
                removed &= this.values.remove(value);
            }
        }
        return removed;
    }

    @Override
    public boolean remove(String ... vals) {
        if (this.isHR == null || this.values.size() == 0) {
            return false;
        }
        boolean removed = true;
        if (this.isHR.booleanValue()) {
            for (String val : vals) {
                StringValue value = new StringValue(val);
                removed &= this.values.remove(value);
            }
        } else {
            for (String val : vals) {
                BinaryValue value = new BinaryValue(StringTools.getBytesUtf8(val));
                removed &= this.values.remove(value);
            }
        }
        return removed;
    }

    @Override
    public Iterator<Value<?>> iterator() {
        return this.values.iterator();
    }

    @Override
    public int put(String ... vals) {
        this.values.clear();
        return this.add(vals);
    }

    @Override
    public int put(byte[] ... vals) {
        this.values.clear();
        return this.add(vals);
    }

    @Override
    public int put(Value<?> ... vals) {
        this.values.clear();
        return this.add(vals);
    }

    @Override
    public int put(List<Value<?>> vals) {
        this.values.clear();
        Value[] valArray = new Value[vals.size()];
        return this.add(vals.toArray(valArray));
    }

    @Override
    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    @Override
    public void setAttributeType(AttributeType attributeType) {
        if (attributeType == null) {
            throw new IllegalArgumentException("The AttributeType parameter should not be null");
        }
        this.attributeType = attributeType;
        this.setUpId(null, attributeType);
        this.isHR = attributeType.getSyntax().isHumanReadable() ? Boolean.valueOf(true) : Boolean.valueOf(false);
    }

    @Override
    public boolean instanceOf(String attributeId) throws LdapInvalidAttributeValueException {
        String trimmedId = StringTools.trim(attributeId);
        if (StringTools.isEmpty(trimmedId)) {
            return false;
        }
        String normId = StringTools.lowerCaseAscii(trimmedId);
        for (String name : this.attributeType.getNames()) {
            if (!normId.equalsIgnoreCase(name)) continue;
            return true;
        }
        return normId.equalsIgnoreCase(this.attributeType.getOid());
    }

    @Override
    public EntryAttribute toClientAttribute() {
        DefaultClientAttribute clientAttribute = new DefaultClientAttribute(this.upId);
        for (Value<?> value : this) {
            AbstractValue clientValue = null;
            clientValue = value instanceof StringValue ? new StringValue(value.getString()) : new BinaryValue(value.getBytes());
            clientAttribute.add(clientValue);
        }
        return clientAttribute;
    }

    public int hashCode() {
        int h = 37;
        if (this.isHR != null) {
            h = h * 17 + this.isHR.hashCode();
        }
        if (this.id != null) {
            h = h * 17 + this.id.hashCode();
        }
        for (Value<?> value : this.values) {
            h = h * 17 + value.hashCode();
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntryAttribute)) {
            return false;
        }
        EntryAttribute other = (EntryAttribute)obj;
        if (this.id == null) {
            if (other.getId() != null) {
                return false;
            }
        } else {
            if (other.getId() == null) {
                return false;
            }
            if (!this.id.equals(other.getId())) {
                return false;
            }
        }
        if (this.isHR() != other.isHR()) {
            return false;
        }
        if (this.values.size() != other.size()) {
            return false;
        }
        for (Value<?> val : this.values) {
            if (other.contains(val)) continue;
            return false;
        }
        return true;
    }

    @Override
    public EntryAttribute clone() {
        try {
            DefaultClientAttribute attribute = (DefaultClientAttribute)super.clone();
            attribute.values = new LinkedHashSet(this.values.size());
            for (Value<?> value : this.values) {
                attribute.values.add(value.clone());
            }
            return attribute;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.values != null && this.values.size() != 0) {
            for (Value<?> value : this.values) {
                sb.append("    ").append(this.upId).append(": ");
                if (value.isNull()) {
                    sb.append("''");
                } else {
                    sb.append(value);
                }
                sb.append('\n');
            }
        } else {
            sb.append("    ").append(this.upId).append(": (null)\n");
        }
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.upId);
        if (this.isHR != null) {
            out.writeBoolean(true);
            out.writeBoolean(this.isHR);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.size());
        if (this.size() > 0) {
            for (Value<?> value : this.values) {
                out.writeObject(value);
            }
        }
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int nbValues;
        this.upId = in.readUTF();
        this.setUpId(this.upId);
        if (in.readBoolean()) {
            this.isHR = in.readBoolean();
        }
        if ((nbValues = in.readInt()) > 0) {
            for (int i = 0; i < nbValues; ++i) {
                this.values.add((Value)in.readObject());
            }
        }
    }
}

