/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search.controls.subentries;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.BooleanDecoder;
import org.apache.directory.shared.asn1.util.BooleanDecoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.search.controls.subentries.SubentriesControl;
import org.apache.directory.shared.ldap.codec.search.controls.subentries.SubentriesControlContainer;
import org.apache.directory.shared.ldap.codec.search.controls.subentries.SubentriesControlStatesEnum;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubentriesControlGrammar
extends AbstractGrammar {
    static final Logger log = LoggerFactory.getLogger(SubentriesControlGrammar.class);
    private static IGrammar instance = new SubentriesControlGrammar();

    private SubentriesControlGrammar() {
        this.name = SubentriesControlGrammar.class.getName();
        this.statesEnum = SubentriesControlStatesEnum.getInstance();
        this.transitions = new GrammarTransition[2][256];
        this.transitions[0][1] = new GrammarTransition(0, 1, 1, new GrammarAction("SubEntryControl visibility"){

            public void action(IAsn1Container container) throws DecoderException {
                SubentriesControlContainer subEntryContainer = (SubentriesControlContainer)container;
                SubentriesControl control = subEntryContainer.getSubEntryControl();
                TLV tlv = subEntryContainer.getCurrentTLV();
                Value value = tlv.getValue();
                try {
                    control.setVisibility(BooleanDecoder.parse(value));
                    container.grammarEndAllowed(true);
                }
                catch (BooleanDecoderException bde) {
                    log.error(I18n.err("ERR_04054", StringTools.dumpBytes(value.getData()), bde.getMessage()));
                    throw new DecoderException(bde.getMessage());
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

