/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search.controls.pagedSearch;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.IntegerDecoder;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.search.controls.pagedSearch.PagedResultsControlContainer;
import org.apache.directory.shared.ldap.codec.search.controls.pagedSearch.PagedResultsControlStatesEnum;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagedResultsControlGrammar
extends AbstractGrammar {
    static final Logger log = LoggerFactory.getLogger(PagedResultsControlGrammar.class);
    static final boolean IS_DEBUG = log.isDebugEnabled();
    private static IGrammar instance = new PagedResultsControlGrammar();

    private PagedResultsControlGrammar() {
        this.name = PagedResultsControlGrammar.class.getName();
        this.statesEnum = PagedResultsControlStatesEnum.getInstance();
        this.transitions = new GrammarTransition[8][256];
        this.transitions[0][48] = new GrammarTransition(0, 1, 48, null);
        this.transitions[1][2] = new GrammarTransition(1, 3, 2, new GrammarAction("Set PagedSearchControl size"){

            public void action(IAsn1Container container) throws DecoderException {
                PagedResultsControlContainer pagedSearchContainer = (PagedResultsControlContainer)container;
                Value value = pagedSearchContainer.getCurrentTLV().getValue();
                try {
                    int size = IntegerDecoder.parse(value, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    if (size < 0) {
                        size = Integer.MAX_VALUE;
                    }
                    if (IS_DEBUG) {
                        log.debug("size = " + size);
                    }
                    pagedSearchContainer.getPagedSearchControl().setSize(size);
                }
                catch (IntegerDecoderException e) {
                    String msg = I18n.err("ERR_04050", new Object[0]);
                    log.error(msg, (Throwable)e);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[3][4] = new GrammarTransition(3, 5, 4, new GrammarAction("Set PagedSearchControl cookie"){

            public void action(IAsn1Container container) throws DecoderException {
                PagedResultsControlContainer pagedSearchContainer = (PagedResultsControlContainer)container;
                Value value = pagedSearchContainer.getCurrentTLV().getValue();
                if (pagedSearchContainer.getCurrentTLV().getLength() == 0) {
                    pagedSearchContainer.getPagedSearchControl().setCookie(StringTools.EMPTY_BYTES);
                } else {
                    pagedSearchContainer.getPagedSearchControl().setCookie(value.getData());
                }
                pagedSearchContainer.grammarEndAllowed(true);
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

