/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.request;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;

public class BatchRequest {
    private List<LdapMessageCodec> requests = new ArrayList<LdapMessageCodec>();
    private int requestID;
    private Processing processing;
    private OnError onError;
    private ResponseOrder responseOrder = ResponseOrder.SEQUENTIAL;

    public BatchRequest() {
        this.processing = Processing.SEQUENTIAL;
        this.onError = OnError.EXIT;
    }

    public boolean addRequest(LdapMessageCodec request) {
        return this.requests.add(request);
    }

    public LdapMessageCodec getCurrentRequest() {
        return this.requests.get(this.requests.size() - 1);
    }

    public int getRequestID() {
        return this.requestID;
    }

    public void setRequestID(int requestID) {
        this.requestID = requestID;
    }

    public Processing getProcessing() {
        return this.processing;
    }

    public void setProcessing(Processing processing) {
        this.processing = processing;
    }

    public OnError getOnError() {
        return this.onError;
    }

    public void setOnError(OnError onError) {
        this.onError = onError;
    }

    public ResponseOrder getResponseOrder() {
        return this.responseOrder;
    }

    public void setResponseOrder(ResponseOrder responseOrder) {
        this.responseOrder = responseOrder;
    }

    public List getRequests() {
        return this.requests;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append("processing: " + (Object)((Object)this.processing));
        sb.append(" - ");
        sb.append("onError: " + (Object)((Object)this.onError));
        sb.append(" - ");
        sb.append("responseOrder: " + (Object)((Object)this.responseOrder));
        sb.append("]");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResponseOrder {
        SEQUENTIAL,
        UNORDERED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OnError {
        RESUME,
        EXIT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Processing {
        SEQUENTIAL,
        PARALLEL;

    }
}

