/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.util;

import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.util.LongDecoderException;
import org.apache.directory.shared.i18n.I18n;

public class LongDecoder {
    private static final long[] MASK = new long[]{255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, -1L};

    public static long parse(Value value, long min, long max) throws LongDecoderException {
        long result = 0L;
        byte[] bytes = value.getData();
        if (bytes == null || bytes.length == 0) {
            throw new LongDecoderException(I18n.err("ERR_00039", new Object[0]));
        }
        if (bytes.length > 8) {
            throw new LongDecoderException(I18n.err("ERR_00039", new Object[0]));
        }
        for (int i = 0; i < bytes.length && i < 9; ++i) {
            result = result << 8 | (long)(bytes[i] & 0xFF);
        }
        if ((bytes[0] & 0x80) == 128) {
            result = -((result ^ 0xFFFFFFFFFFFFFFFFL) + 1L & MASK[bytes.length - 1]);
        }
        if (result >= min && result <= max) {
            return result;
        }
        throw new LongDecoderException(I18n.err("ERR_00038", min, max));
    }

    public static long parse(Value value) throws LongDecoderException {
        return LongDecoder.parse(value, Long.MIN_VALUE, Long.MAX_VALUE);
    }
}

