/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.shared.messages.value.types.HostAddrType;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostAddress
extends AbstractAsn1Object {
    private static final Logger LOG = LoggerFactory.getLogger(HostAddress.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private HostAddrType addrType;
    private byte[] address;
    private transient int addrTypeLength;
    private transient int addressLength;
    private transient int hostAddressLength;
    private transient int hostAddressSeqLength;

    public HostAddress(HostAddrType addrType, byte[] address) {
        this.addrType = addrType;
        this.address = address;
    }

    public HostAddress(InetAddress internetAddress) {
        this.addrType = HostAddrType.ADDRTYPE_INET;
        byte[] newAddress = internetAddress.getAddress();
        this.address = new byte[newAddress.length];
        System.arraycopy(newAddress, 0, this.address, 0, newAddress.length);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof HostAddress)) {
            return false;
        }
        HostAddress hostAddress = (HostAddress)that;
        if (this.addrType != hostAddress.addrType || this.address != null && hostAddress.address == null || this.address == null && hostAddress.address != null) {
            return false;
        }
        if (this.address != null && hostAddress.address != null) {
            if (this.address.length != hostAddress.address.length) {
                return false;
            }
            for (int ii = 0; ii < this.address.length; ++ii) {
                if (this.address[ii] == hostAddress.address[ii]) continue;
                return false;
            }
        }
        return true;
    }

    public byte[] getAddress() {
        return this.address;
    }

    public void setAddress(byte[] addresse) {
        this.address = addresse;
    }

    public int computeLength() {
        this.addrTypeLength = 2 + Value.getNbBytes(this.addrType.getOrdinal());
        this.hostAddressLength = 1 + TLV.getNbBytes(this.addrTypeLength) + this.addrTypeLength;
        this.addressLength = this.address == null ? 2 : 1 + TLV.getNbBytes(this.address.length) + this.address.length;
        this.hostAddressLength += 1 + TLV.getNbBytes(this.addressLength) + this.addressLength;
        this.hostAddressSeqLength = 1 + Value.getNbBytes(this.hostAddressLength) + this.hostAddressLength;
        return this.hostAddressSeqLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_148, new Object[0]));
        }
        try {
            buffer.put((byte)48);
            buffer.put(TLV.getBytes(this.hostAddressLength));
            buffer.put((byte)-96);
            buffer.put(TLV.getBytes(this.addrTypeLength));
            Value.encode(buffer, this.addrType.getOrdinal());
            buffer.put((byte)-95);
            buffer.put(TLV.getBytes(this.addressLength));
            Value.encode(buffer, this.address);
        }
        catch (BufferOverflowException boe) {
            LOG.error(I18n.err(I18n.ERR_143, 1 + TLV.getNbBytes(this.hostAddressLength) + this.hostAddressLength, buffer.capacity()));
            throw new EncoderException(I18n.err(I18n.ERR_138, new Object[0]));
        }
        if (IS_DEBUG) {
            LOG.debug("Checksum encoding : {}", (Object)StringTools.dumpBytes(buffer.array()));
            LOG.debug("Checksum initial value : {}", (Object)this.toString());
        }
        return buffer;
    }

    public HostAddrType getAddrType() {
        return this.addrType;
    }

    public void setAddrType(HostAddrType addrType) {
        this.addrType = addrType;
    }

    public void setAddrType(int addrType) {
        this.addrType = HostAddrType.getTypeByOrdinal(addrType);
    }

    public String toString() {
        String result = "";
        try {
            result = InetAddress.getByAddress(this.address).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return result;
    }
}

