/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.directory.server.kerberos.shared.io.encoder.EncryptedDataEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.PrincipalNameEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.TicketEncoder;
import org.apache.directory.server.kerberos.shared.messages.KdcReply;
import org.apache.directory.server.kerberos.shared.messages.value.PaData;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DERGeneralString;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DEROctetString;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class KdcReplyEncoder {
    public void encode(KdcReply app, ByteBuffer out) throws IOException {
        ASN1OutputStream aos = new ASN1OutputStream(out);
        DERSequence kdcrep = this.encodeKdcReplySequence(app);
        aos.writeObject(DERApplicationSpecific.valueOf(app.getMessageType().getOrdinal(), kdcrep));
        aos.close();
    }

    private DERSequence encodeKdcReplySequence(KdcReply app) {
        DERSequence sequence = new DERSequence();
        sequence.add(new DERTaggedObject(0, DERInteger.valueOf(app.getProtocolVersionNumber())));
        sequence.add(new DERTaggedObject(1, DERInteger.valueOf(app.getMessageType().getOrdinal())));
        if (app.getPaData() != null) {
            sequence.add(new DERTaggedObject(2, this.encodePreAuthData(app.getPaData())));
        }
        sequence.add(new DERTaggedObject(3, DERGeneralString.valueOf(app.getClientRealm().toString())));
        sequence.add(new DERTaggedObject(4, PrincipalNameEncoder.encode(app.getClientPrincipal())));
        sequence.add(new DERTaggedObject(5, TicketEncoder.encode(app.getTicket())));
        sequence.add(new DERTaggedObject(6, EncryptedDataEncoder.encodeSequence(app.getEncPart())));
        return sequence;
    }

    private DERSequence encodePreAuthData(PaData[] preAuthData) {
        DERSequence preAuth = new DERSequence();
        for (int ii = 0; ii < preAuthData.length; ++ii) {
            DERSequence sequence = new DERSequence();
            sequence.add(new DERTaggedObject(1, DERInteger.valueOf(preAuthData[ii].getPaDataType().getOrdinal())));
            sequence.add(new DERTaggedObject(2, new DEROctetString(preAuthData[ii].getPaDataValue())));
            preAuth.add(sequence);
        }
        return preAuth;
    }
}

