/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.registries.ObjectClassRegistry;
import org.apache.directory.shared.ldap.util.NamespaceTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaChecker {
    private static Logger log = LoggerFactory.getLogger(SchemaChecker.class);

    public static void preventStructuralClassRemovalOnModifyReplace(SchemaManager schemaManager, DN name, ModificationOperation mod, EntryAttribute attribute) throws LdapException {
        if (mod != ModificationOperation.REPLACE_ATTRIBUTE) {
            return;
        }
        if (!"objectClass".equalsIgnoreCase(attribute.getUpId())) {
            return;
        }
        if (attribute.size() == 0) {
            String msg = I18n.err(I18n.ERR_272, name);
            if (log.isInfoEnabled()) {
                log.info(msg + ".  Raising LdapSchemaViolationException.");
            }
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_MODS_PROHIBITED, msg);
        }
        for (Value value : attribute) {
            ObjectClass ocType = (ObjectClass)schemaManager.getObjectClassRegistry().lookup(value.getString());
            if (ocType.getType() != ObjectClassTypeEnum.STRUCTURAL) continue;
            return;
        }
        String msg = I18n.err(I18n.ERR_272, name);
        if (log.isInfoEnabled()) {
            log.info(msg + ".  Raising LdapSchemaViolationException.");
        }
        throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_MODS_PROHIBITED, msg);
    }

    public static void preventStructuralClassRemovalOnModifyReplace(ObjectClassRegistry registry, DN name, ModificationOperation mod, ServerEntry entry) throws LdapException {
        if (mod != ModificationOperation.REPLACE_ATTRIBUTE) {
            return;
        }
        EntryAttribute objectClass = entry.get("objectClass");
        if (objectClass == null) {
            return;
        }
        if (objectClass.size() == 0) {
            String msg = I18n.err(I18n.ERR_272, name);
            if (log.isInfoEnabled()) {
                log.info(msg + ".  Raising LdapSchemaViolationException.");
            }
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_MODS_PROHIBITED, msg);
        }
        for (Value value : objectClass) {
            ObjectClass ocType = (ObjectClass)registry.lookup(value.getString());
            if (ocType.getType() != ObjectClassTypeEnum.STRUCTURAL) continue;
            return;
        }
        String msg = I18n.err(I18n.ERR_272, name);
        if (log.isInfoEnabled()) {
            log.info(msg + ".  Raising LdapSchemaViolationException.");
        }
        throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_MODS_PROHIBITED, msg);
    }

    public static void preventStructuralClassRemovalOnModifyRemove(SchemaManager schemaManager, DN name, ModificationOperation mod, EntryAttribute attribute, EntryAttribute entryObjectClasses) throws LdapException {
        if (mod != ModificationOperation.REMOVE_ATTRIBUTE) {
            return;
        }
        if (!attribute.instanceOf("objectClass")) {
            return;
        }
        ArrayList<Value> removed = new ArrayList<Value>();
        for (Value value : attribute) {
            if (value.getString().length() != 0) continue;
            removed.add(value);
        }
        for (Value value : removed) {
            attribute.remove(value);
        }
        if (attribute.size() == 0) {
            String msg = I18n.err(I18n.ERR_272, name);
            if (log.isInfoEnabled()) {
                log.info(msg + ".  Raising LdapSchemaViolationException.");
            }
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_MODS_PROHIBITED, msg);
        }
        EntryAttribute cloned = entryObjectClasses.clone();
        for (Value value : attribute) {
            cloned.remove(value);
        }
        for (Value objectClass : cloned) {
            ObjectClass oc = (ObjectClass)schemaManager.getObjectClassRegistry().lookup(objectClass.getString());
            if (oc.getType() != ObjectClassTypeEnum.STRUCTURAL) continue;
            return;
        }
        String msg = I18n.err(I18n.ERR_272, name);
        if (log.isInfoEnabled()) {
            log.info(msg + ".  Raising LdapSchemaViolationException.");
        }
        throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_MODS_PROHIBITED, msg);
    }

    public static void preventRdnChangeOnModifyReplace(DN name, ModificationOperation mod, EntryAttribute attribute, SchemaManager schemaManager) throws LdapException {
        String id;
        if (mod != ModificationOperation.REPLACE_ATTRIBUTE) {
            return;
        }
        Set<String> rdnAttributes = SchemaChecker.getRdnAttributes(name);
        if (!rdnAttributes.contains(id = schemaManager.getAttributeTypeRegistry().getOidByName(attribute.getUpId()))) {
            return;
        }
        if (attribute.size() == 0) {
            String msg = I18n.err(I18n.ERR_273, id, name);
            if (log.isInfoEnabled()) {
                log.info(msg + ". SchemaChecker is throwing a schema violation exception.");
            }
            throw new LdapSchemaViolationException(ResultCodeEnum.NOT_ALLOWED_ON_RDN, msg);
        }
        String rdnValue = SchemaChecker.getRdnValue(id, name, schemaManager);
        for (int ii = 0; ii < attribute.size(); ++ii) {
            if (attribute.contains(rdnValue)) continue;
            String msg = I18n.err(I18n.ERR_274, id, name);
            if (log.isInfoEnabled()) {
                log.info(msg + ". SchemaChecker is throwing a schema violation exception.");
            }
            throw new LdapSchemaViolationException(ResultCodeEnum.NOT_ALLOWED_ON_RDN, msg);
        }
    }

    public static void preventRdnChangeOnModifyReplace(DN name, ModificationOperation mod, ServerEntry entry, SchemaManager schemaManager) throws LdapException {
        if (mod != ModificationOperation.REPLACE_ATTRIBUTE) {
            return;
        }
        Set<String> rdnAttributes = SchemaChecker.getRdnAttributes(name);
        for (AttributeType attributeType : entry.getAttributeTypes()) {
            String id = attributeType.getName();
            if (!rdnAttributes.contains(id)) continue;
            EntryAttribute rdnAttr = entry.get(id);
            if (rdnAttr.size() == 0) {
                String msg = I18n.err(I18n.ERR_273, id, name);
                if (log.isInfoEnabled()) {
                    log.info(msg + ". SchemaChecker is throwing a schema violation exception.");
                }
                throw new LdapSchemaViolationException(ResultCodeEnum.NOT_ALLOWED_ON_RDN, msg);
            }
            String rdnValue = SchemaChecker.getRdnValue(id, name, schemaManager);
            if (rdnAttr.contains(rdnValue)) continue;
            String msg = I18n.err(I18n.ERR_274, id, name);
            if (log.isInfoEnabled()) {
                log.info(msg + ". SchemaChecker is throwing a schema violation exception.");
            }
            throw new LdapSchemaViolationException(ResultCodeEnum.NOT_ALLOWED_ON_RDN, msg);
        }
    }

    public static void preventRdnChangeOnModifyRemove(DN name, ModificationOperation mod, EntryAttribute attribute, SchemaManager schemaManager) throws LdapException {
        if (mod != ModificationOperation.REMOVE_ATTRIBUTE) {
            return;
        }
        Set<String> rdnAttributes = SchemaChecker.getRdnAttributes(name);
        String id = attribute.getId();
        if (!rdnAttributes.contains(schemaManager.getAttributeTypeRegistry().getOidByName(id))) {
            return;
        }
        if (attribute.size() == 0) {
            String msg = I18n.err(I18n.ERR_273, id, name);
            if (log.isInfoEnabled()) {
                log.info(msg + ". SchemaChecker is throwing a schema violation exception.");
            }
            throw new LdapSchemaViolationException(ResultCodeEnum.NOT_ALLOWED_ON_RDN, msg);
        }
        String rdnValue = SchemaChecker.getRdnValue(id, name, schemaManager);
        for (Value value : attribute) {
            if (!rdnValue.equals(value.getString())) continue;
            String msg = I18n.err(I18n.ERR_274, id, name);
            if (log.isInfoEnabled()) {
                log.info(msg + ". SchemaChecker is throwing a schema violation exception.");
            }
            throw new LdapSchemaViolationException(ResultCodeEnum.NOT_ALLOWED_ON_RDN, msg);
        }
    }

    public static void preventRdnChangeOnModifyRemove(DN name, ModificationOperation mod, ServerEntry entry, SchemaManager schemaManager) throws LdapException {
        if (mod != ModificationOperation.REMOVE_ATTRIBUTE) {
            return;
        }
        Set<String> rdnAttributes = SchemaChecker.getRdnAttributes(name);
        for (AttributeType attributeType : entry.getAttributeTypes()) {
            String id = attributeType.getName();
            if (!rdnAttributes.contains(id)) continue;
            if (entry.get(id).size() == 0) {
                String msg = I18n.err(I18n.ERR_273, id, name);
                if (log.isInfoEnabled()) {
                    log.info(msg + ". SchemaChecker is throwing a schema violation exception.");
                }
                throw new LdapSchemaViolationException(ResultCodeEnum.NOT_ALLOWED_ON_RDN, msg);
            }
            String rdnValue = SchemaChecker.getRdnValue(id, name, schemaManager);
            EntryAttribute rdnAttr = entry.get(id);
            for (Value value : rdnAttr) {
                if (!rdnValue.equals(value.getString())) continue;
                String msg = I18n.err(I18n.ERR_274, id, name);
                if (log.isInfoEnabled()) {
                    log.info(msg + ". SchemaChecker is throwing a schema violation exception.");
                }
                throw new LdapSchemaViolationException(ResultCodeEnum.NOT_ALLOWED_ON_RDN, msg);
            }
        }
    }

    private static String getRdnValue(String id, DN name, SchemaManager schemaManager) throws LdapException {
        String idOid = schemaManager.getAttributeTypeRegistry().getOidByName(id);
        if (idOid == null) {
            log.error(I18n.err(I18n.ERR_43, id));
            throw new LdapException(I18n.err(I18n.ERR_44, id));
        }
        String[] comps = NamespaceTools.getCompositeComponents(name.get(name.size() - 1));
        for (int ii = 0; ii < comps.length; ++ii) {
            String rdnAttrId = NamespaceTools.getRdnAttribute(comps[ii]);
            String rdnAttrOid = schemaManager.getAttributeTypeRegistry().getOidByName(rdnAttrId);
            if (rdnAttrOid == null) {
                log.error(I18n.err(I18n.ERR_43, rdnAttrOid));
                throw new LdapException(I18n.err(I18n.ERR_44, rdnAttrOid));
            }
            if (!rdnAttrOid.equalsIgnoreCase(idOid)) continue;
            return NamespaceTools.getRdnValue(comps[ii]);
        }
        return null;
    }

    private static Set<String> getRdnAttributes(DN name) throws LdapException {
        String[] comps = NamespaceTools.getCompositeComponents(name.get(name.size() - 1));
        HashSet<String> attributes = new HashSet<String>();
        for (int ii = 0; ii < comps.length; ++ii) {
            attributes.add(NamespaceTools.getRdnAttribute(comps[ii]));
        }
        return attributes;
    }
}

