/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.IOException;
import jdbm.helper.Serializer;

public class StringSerializer
implements Serializer {
    private static final long serialVersionUID = -173163945773783649L;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public Object deserialize(byte[] bites) throws IOException {
        if (bites.length == 0) {
            return "";
        }
        char[] strchars = new char[bites.length >> 1];
        int ii = 0;
        int jj = 0;
        while (ii < strchars.length) {
            int ch = bites[jj] << 8 & 0xFF00;
            strchars[ii] = (char)(ch |= bites[jj + 1] & 0xFF);
            jj = ++ii << 1;
        }
        return new String(strchars);
    }

    public byte[] serialize(Object str) throws IOException {
        if (((String)str).length() == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        char[] strchars = ((String)str).toCharArray();
        byte[] bites = new byte[strchars.length << 1];
        int ii = 0;
        int jj = 0;
        while (ii < strchars.length) {
            bites[jj] = (byte)(strchars[ii] >> 8 & 0xFF);
            bites[jj + 1] = (byte)(strchars[ii] & 0xFF);
            jj = ++ii << 1;
        }
        return bites;
    }
}

