/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.changepw.service;

import java.util.ArrayList;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.changepw.ChangePasswordServer;
import org.apache.directory.server.changepw.exceptions.ChangePasswordException;
import org.apache.directory.server.changepw.exceptions.ErrorType;
import org.apache.directory.server.changepw.service.ChangePasswordContext;
import org.apache.directory.server.kerberos.shared.messages.components.Authenticator;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckPasswordPolicy
implements IoHandlerCommand {
    private static final Logger log = LoggerFactory.getLogger(CheckPasswordPolicy.class);
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        int tokenSize;
        int categoryCount;
        int passwordLength;
        ChangePasswordContext changepwContext = (ChangePasswordContext)session.getAttribute((Object)this.getContextKey());
        ChangePasswordServer config = changepwContext.getConfig();
        Authenticator authenticator = changepwContext.getAuthenticator();
        KerberosPrincipal clientPrincipal = authenticator.getClientPrincipal();
        String password = changepwContext.getPassword();
        String username = clientPrincipal.getName();
        if (!this.isValid(username, password, passwordLength = config.getPasswordLengthPolicy(), categoryCount = config.getCategoryCountPolicy(), tokenSize = config.getTokenSizePolicy())) {
            String explanation = this.buildErrorMessage(username, password, passwordLength, categoryCount, tokenSize);
            log.error(explanation);
            byte[] explanatoryData = explanation.getBytes("UTF-8");
            throw new ChangePasswordException(ErrorType.KRB5_KPASSWD_SOFTERROR, explanatoryData);
        }
        next.execute(session, message);
    }

    boolean isValid(String username, String password, int passwordLength, int categoryCount, int tokenSize) {
        return this.isValidPasswordLength(password, passwordLength) && this.isValidCategoryCount(password, categoryCount) && this.isValidUsernameSubstring(username, password, tokenSize);
    }

    boolean isValidPasswordLength(String password, int passwordLength) {
        return password.length() >= passwordLength;
    }

    boolean isValidCategoryCount(String password, int categoryCount) {
        int uppercase = 0;
        int lowercase = 0;
        int digit = 0;
        int nonAlphaNumeric = 0;
        char[] characters = password.toCharArray();
        for (int ii = 0; ii < characters.length; ++ii) {
            if (Character.isLowerCase(characters[ii])) {
                lowercase = 1;
                continue;
            }
            if (Character.isUpperCase(characters[ii])) {
                uppercase = 1;
                continue;
            }
            if (Character.isDigit(characters[ii])) {
                digit = 1;
                continue;
            }
            if (Character.isLetterOrDigit(characters[ii])) continue;
            nonAlphaNumeric = 1;
        }
        return uppercase + lowercase + digit + nonAlphaNumeric >= categoryCount;
    }

    boolean isValidUsernameSubstring(String username, String password, int tokenSize) {
        String[] tokens = username.split("[^a-zA-Z]");
        for (int ii = 0; ii < tokens.length; ++ii) {
            if (tokens[ii].length() < tokenSize || !password.matches("(?i).*" + tokens[ii] + ".*")) continue;
            return false;
        }
        return true;
    }

    private String buildErrorMessage(String username, String password, int passwordLength, int categoryCount, int tokenSize) {
        ArrayList<String> violations = new ArrayList<String>();
        if (!this.isValidPasswordLength(password, passwordLength)) {
            violations.add("length too short");
        }
        if (!this.isValidCategoryCount(password, categoryCount)) {
            violations.add("insufficient character mix");
        }
        if (!this.isValidUsernameSubstring(username, password, tokenSize)) {
            violations.add("contains portions of username");
        }
        StringBuffer sb = new StringBuffer("Password violates policy:  ");
        boolean isFirst = true;
        for (String violation : violations) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(violation);
        }
        return sb.toString();
    }

    protected String getContextKey() {
        return this.contextKey;
    }
}

