/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.dosgi.tcp;

import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import org.fusesource.fabric.dosgi.io.ProtocolCodec;
import org.fusesource.hawtbuf.Buffer;

public class LengthPrefixedCodec
implements ProtocolCodec {
    int write_buffer_size = 65536;
    long write_counter = 0L;
    WritableByteChannel write_channel;
    ByteBuffer write_buffer = ByteBuffer.allocate(0);
    ArrayList<Buffer> next_write_buffers = new ArrayList();
    int next_write_size = 0;
    long read_counter = 0L;
    int read_buffer_size = 65536;
    ReadableByteChannel read_channel = null;
    ByteBuffer read_buffer = ByteBuffer.allocate(4);

    @Override
    public boolean full() {
        return this.next_write_size >= this.write_buffer_size >> 1;
    }

    protected boolean empty() {
        return this.write_buffer.remaining() == 0 && this.next_write_size == 0;
    }

    @Override
    public void setWritableByteChannel(WritableByteChannel channel) {
        this.write_channel = channel;
        if (channel instanceof SocketChannel) {
            try {
                ((SocketChannel)channel).socket().setSendBufferSize(this.write_buffer_size);
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ProtocolCodec.BufferState write(Object value) throws IOException {
        if (this.full()) {
            return ProtocolCodec.BufferState.FULL;
        }
        boolean wasEmpty = this.empty();
        Buffer buffer = (Buffer)value;
        this.next_write_size += buffer.length;
        this.next_write_buffers.add(buffer);
        return wasEmpty ? ProtocolCodec.BufferState.WAS_EMPTY : ProtocolCodec.BufferState.NOT_EMPTY;
    }

    @Override
    public ProtocolCodec.BufferState flush() throws IOException {
        if (this.write_buffer.remaining() == 0 && this.next_write_size > 0) {
            if (this.next_write_buffers.size() == 1) {
                this.write_buffer = this.next_write_buffers.remove(0).toByteBuffer();
            } else {
                if (this.write_buffer.capacity() < this.next_write_size) {
                    this.write_buffer = ByteBuffer.allocate(this.next_write_size);
                } else if (this.next_write_size < this.write_buffer_size && this.write_buffer.capacity() > this.write_buffer_size) {
                    this.write_buffer = ByteBuffer.allocate(this.next_write_size);
                }
                this.write_buffer.clear();
                for (Buffer b : this.next_write_buffers) {
                    this.write_buffer.put(b.data, b.offset, b.length);
                }
                this.next_write_buffers.clear();
                this.next_write_size = 0;
                this.write_buffer.flip();
            }
        }
        if (this.write_buffer.remaining() != 0) {
            this.write_counter += (long)this.write_channel.write(this.write_buffer);
        }
        return this.empty() ? ProtocolCodec.BufferState.EMPTY : ProtocolCodec.BufferState.NOT_EMPTY;
    }

    @Override
    public long getWriteCounter() {
        return this.write_counter;
    }

    @Override
    public void setReadableByteChannel(ReadableByteChannel channel) {
        this.read_channel = channel;
        if (channel instanceof SocketChannel) {
            try {
                ((SocketChannel)channel).socket().setReceiveBufferSize(this.read_buffer_size);
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Object read() throws IOException {
        while (true) {
            if (this.read_buffer.remaining() != 0) {
                int count = this.read_channel.read(this.read_buffer);
                if (count == -1) {
                    throw new EOFException("Peer disconnected");
                }
                if (count == 0) {
                    return null;
                }
                this.read_counter += (long)count;
                continue;
            }
            this.read_buffer.flip();
            if (this.read_buffer.capacity() != 4) break;
            int size = this.read_buffer.getInt(0);
            if (size < 4) {
                throw new ProtocolException("Expecting a size greater than 3");
            }
            if (size == 4) {
                Buffer rc = new Buffer(this.read_buffer);
                this.read_buffer = ByteBuffer.allocate(4);
                return rc;
            }
            ByteBuffer next = ByteBuffer.allocate(size);
            next.putInt(size);
            this.read_buffer = next;
        }
        Buffer rc = new Buffer(this.read_buffer);
        this.read_buffer = ByteBuffer.allocate(4);
        return rc;
    }

    @Override
    public long getReadCounter() {
        return this.read_counter;
    }
}

