/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.cxf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Retryable;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.transport.Conduit;
import org.fusesource.fabric.cxf.LoadBalanceTargetSelector;

public class FailOverTargetSelector
extends LoadBalanceTargetSelector {
    private static final Logger LOG = LogUtils.getL7dLogger(FailOverTargetSelector.class);
    protected Map<InvocationKey, InvocationContext> inProgress = new ConcurrentHashMap<InvocationKey, InvocationContext>();
    protected List<Class> exceptionClasses;

    public FailOverTargetSelector(List<Class> exceptions) {
        this(null, exceptions);
    }

    public FailOverTargetSelector(Conduit c, List<Class> exceptions) {
        super(c);
        this.exceptionClasses = exceptions != null ? exceptions : new ArrayList<Class>();
        if (!this.exceptionClasses.contains(IOException.class)) {
            this.exceptionClasses.add(IOException.class);
        }
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public synchronized void prepare(Message message) {
        Exchange exchange = message.getExchange();
        InvocationKey key = new InvocationKey(exchange);
        if (!this.inProgress.containsKey(key)) {
            Endpoint endpoint = (Endpoint)exchange.get(Endpoint.class);
            BindingOperationInfo bindingOperationInfo = exchange.getBindingOperationInfo();
            Object[] params = ((List)message.getContent(List.class)).toArray();
            Map context = CastUtils.cast((Map)((Map)message.get((Object)"org.apache.cxf.invocation.context")));
            InvocationContext invocation = new InvocationContext(endpoint, bindingOperationInfo, params, context);
            this.inProgress.put(key, invocation);
        }
    }

    @Override
    public void complete(Exchange exchange) {
        InvocationKey key = new InvocationKey(exchange);
        InvocationContext invocation = null;
        invocation = this.inProgress.get(key);
        boolean failOver = false;
        if (this.requiresFailOver(exchange)) {
            Endpoint failOverTarget = this.getFailOverTarget(exchange, invocation);
            if (failOverTarget != null) {
                this.setEndpoint(failOverTarget);
                this.selectedConduit.close();
                this.selectedConduit = null;
                Exception prevExchangeFault = (Exception)exchange.remove((Object)Exception.class.getName());
                Message outMessage = exchange.getOutMessage();
                Exception prevMessageFault = (Exception)outMessage.getContent(Exception.class);
                outMessage.setContent(Exception.class, null);
                this.overrideAddressProperty(invocation.getContext());
                Retryable retry = (Retryable)exchange.get(Retryable.class);
                exchange.clear();
                if (retry != null) {
                    try {
                        failOver = true;
                        retry.invoke(invocation.getBindingOperationInfo(), invocation.getParams(), invocation.getContext(), exchange);
                    }
                    catch (Exception e) {
                        if (exchange.get(Exception.class) != null) {
                            exchange.put(Exception.class, (Object)prevExchangeFault);
                        }
                        if (outMessage.getContent(Exception.class) != null) {
                            outMessage.setContent(Exception.class, (Object)prevMessageFault);
                        }
                    }
                }
            } else {
                this.setEndpoint(invocation.retrieveOriginalEndpoint(this.endpoint));
            }
        }
        if (!failOver) {
            this.getLogger().info("FailOver is not required.");
            this.inProgress.remove(key);
            super.complete(exchange);
        }
    }

    protected boolean requiresFailOver(Exchange exchange) {
        Message outMessage = exchange.getOutMessage();
        Exception ex = outMessage.get(Exception.class) != null ? (Exception)outMessage.get(Exception.class) : (Exception)exchange.get(Exception.class);
        this.getLogger().log(Level.FINE, "Check last invoke failed " + ex);
        boolean failOver = false;
        for (Throwable curr = ex; curr != null && !failOver; curr = curr.getCause()) {
            failOver = this.checkExceptionClasses(curr);
        }
        this.getLogger().log(Level.INFO, "Check failure in transport " + ex + ", failOver is " + failOver);
        return failOver;
    }

    protected boolean checkExceptionClasses(Throwable current) {
        for (Class exceptionClass : this.exceptionClasses) {
            if (!exceptionClass.isInstance(current)) continue;
            return true;
        }
        return false;
    }

    protected Endpoint getFailOverTarget(Exchange exchange, InvocationContext invocation) {
        Endpoint failOverTarget = null;
        if (invocation.getAlternateAddresses() == null) {
            invocation.setAlternateAddresses(this.getLoadBalanceStrategy().getAlternateAddressList());
            invocation.getAlternateAddresses().remove(0);
        }
        String alternateAddress = null;
        if (invocation.getAlternateAddresses().size() > 0) {
            alternateAddress = invocation.getAlternateAddresses().remove(0);
        }
        if (alternateAddress != null) {
            failOverTarget = this.getEndpoint();
            failOverTarget.getEndpointInfo().setAddress(alternateAddress);
        }
        return failOverTarget;
    }

    protected void overrideAddressProperty(Map<String, Object> context) {
        Map requestContext = CastUtils.cast((Map)((Map)context.get("RequestContext")));
        if (requestContext != null) {
            requestContext.put(Message.ENDPOINT_ADDRESS, this.getEndpoint().getEndpointInfo().getAddress());
            requestContext.put("javax.xml.ws.service.endpoint.address", this.getEndpoint().getEndpointInfo().getAddress());
        }
    }

    protected class InvocationContext {
        private Endpoint originalEndpoint;
        private String originalAddress;
        private BindingOperationInfo bindingOperationInfo;
        private Object[] params;
        private Map<String, Object> context;
        private List<String> alternateAddresses;

        InvocationContext(Endpoint endpoint, BindingOperationInfo boi, Object[] prms, Map<String, Object> ctx) {
            this.originalEndpoint = endpoint;
            this.originalAddress = endpoint.getEndpointInfo().getAddress();
            this.bindingOperationInfo = boi;
            this.params = prms;
            this.context = ctx;
        }

        Endpoint retrieveOriginalEndpoint(Endpoint endpoint) {
            if (endpoint != this.originalEndpoint) {
                FailOverTargetSelector.this.getLogger().log(Level.INFO, "Revert to original target " + endpoint.getEndpointInfo().getName());
            }
            if (!endpoint.getEndpointInfo().getAddress().equals(this.originalAddress)) {
                endpoint.getEndpointInfo().setAddress(this.originalAddress);
                FailOverTargetSelector.this.getLogger().log(Level.INFO, "Revert to original address ", endpoint.getEndpointInfo().getAddress());
            }
            return this.originalEndpoint;
        }

        BindingOperationInfo getBindingOperationInfo() {
            return this.bindingOperationInfo;
        }

        Object[] getParams() {
            return this.params;
        }

        Map<String, Object> getContext() {
            return this.context;
        }

        void setAlternateAddresses(List<String> alternates) {
            this.alternateAddresses = alternates;
        }

        List<String> getAlternateAddresses() {
            return this.alternateAddresses;
        }
    }

    protected static class InvocationKey {
        private Exchange exchange;

        InvocationKey(Exchange ex) {
            this.exchange = ex;
        }

        public int hashCode() {
            return System.identityHashCode(this.exchange);
        }

        public boolean equals(Object o) {
            return o instanceof InvocationKey && this.exchange == ((InvocationKey)o).exchange;
        }
    }
}

