/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.cxf;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.endpoint.ServerLifeCycleManager;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.fusesource.fabric.cxf.FabricServerListener;
import org.fusesource.fabric.cxf.LoadBalanceStrategy;
import org.fusesource.fabric.cxf.LoadBalanceTargetSelector;
import org.fusesource.fabric.cxf.RandomLoadBalanceStrategy;
import org.fusesource.fabric.groups.Group;
import org.fusesource.fabric.groups.ZooKeeperGroupFactory;
import org.fusesource.fabric.zookeeper.internal.ZKClientFactoryBean;
import org.linkedin.zookeeper.client.IZKClient;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class FabricLoadBalancerFeature
extends AbstractFeature
implements InitializingBean,
DisposableBean {
    private static final transient Log LOG = LogFactory.getLog(FabricLoadBalancerFeature.class);
    @Autowired
    private IZKClient zkClient;
    private String zkRoot = "/fabric/cxf/endpoints/";
    private String fabricPath;
    private Group group;
    private LoadBalanceStrategy loadBalanceStrategy;
    private List<ACL> accessControlList = ZooDefs.Ids.OPEN_ACL_UNSAFE;

    public void initialize(Client client, Bus bus) {
        LoadBalanceTargetSelector selector = this.getDefaultLoadBalanceTargetSelector();
        selector.setEndpoint(client.getEndpoint());
        selector.setLoadBalanceStrategy(this.getLoadBalanceStrategy());
        client.setConduitSelector((ConduitSelector)selector);
    }

    public void initialize(Bus bus) {
        FabricServerListener lister = new FabricServerListener(this.group);
        ServerLifeCycleManager mgr = (ServerLifeCycleManager)bus.getExtension(ServerLifeCycleManager.class);
        if (mgr != null) {
            mgr.registerListener((ServerLifeCycleListener)lister);
        } else {
            LOG.warn((Object)"Cannot find the ServerLifeCycleManager ");
        }
    }

    protected void checkZkConnected() throws Exception {
        if (!this.zkClient.isConnected()) {
            throw new Exception("Could not connect to ZooKeeper " + this.zkClient);
        }
    }

    protected LoadBalanceStrategy getDefaultLoadBalanceStrategy() {
        return new RandomLoadBalanceStrategy();
    }

    protected LoadBalanceTargetSelector getDefaultLoadBalanceTargetSelector() {
        return new LoadBalanceTargetSelector();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.zkClient == null) {
            this.zkClient = new ZKClientFactoryBean().getObject();
        }
        this.checkZkConnected();
        this.group = ZooKeeperGroupFactory.create(this.getZkClient(), this.zkRoot + this.fabricPath, this.accessControlList);
        if (this.loadBalanceStrategy == null) {
            this.loadBalanceStrategy = this.getDefaultLoadBalanceStrategy();
        }
        this.loadBalanceStrategy.setGroup(this.group);
    }

    public void destroy() throws Exception {
        if (this.zkClient != null) {
            this.zkClient.close();
        }
    }

    public String getFabricPath() {
        return this.fabricPath;
    }

    public void setFabricPath(String fabricPath) {
        this.fabricPath = fabricPath;
    }

    public List<ACL> getAccessControlList() {
        return this.accessControlList;
    }

    public void setAccessControlList(List<ACL> accessControlList) {
        this.accessControlList = accessControlList;
    }

    public IZKClient getZkClient() {
        return this.zkClient;
    }

    public void setZkClient(IZKClient zkClient) {
        this.zkClient = zkClient;
    }

    public LoadBalanceStrategy getLoadBalanceStrategy() {
        return this.loadBalanceStrategy;
    }

    public void setLoadBalanceStrategy(LoadBalanceStrategy strategy) {
        this.loadBalanceStrategy = strategy;
    }
}

