/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.commands.support.ContainerUpgradeSupport;
import org.fusesource.fabric.utils.FabricValidations;

@Command(name="container-upgrade", scope="fabric", description="Upgrade containers to a new version", detailedDescription="classpath:containerUpgrade.txt")
public class ContainerUpgrade
extends ContainerUpgradeSupport {
    @Option(name="--all", description="Upgrade all containers")
    private boolean all;
    @Argument(index=0, name="version", description="The version to upgrade to.", required=true)
    private String version;
    @Argument(index=1, name="container", description="The list of containers to upgrade. An empty list implies the current container.", required=false, multiValued=true)
    private List<String> containerIds;

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        FabricValidations.validateContainersName(this.containerIds);
        Version version = this.fabricService.getVersion(this.version);
        if (this.containerIds == null || this.containerIds.isEmpty()) {
            if (this.all) {
                this.containerIds = new ArrayList<String>();
                for (Container container : this.fabricService.getContainers()) {
                    this.containerIds.add(container.getId());
                }
            } else {
                this.containerIds = Arrays.asList(this.fabricService.getCurrentContainer().getId());
            }
        } else if (this.all) {
            throw new IllegalArgumentException("Can not use --all with a list of containers simultaneously");
        }
        ArrayList<Container> toUpgrade = new ArrayList<Container>();
        ArrayList<Container> same = new ArrayList<Container>();
        for (String containerName : this.containerIds) {
            Container container = this.getContainer(containerName);
            int num = this.canUpgrade(version, container);
            if (num < 0) {
                throw new IllegalArgumentException("Container " + container.getId() + " already has a higher version " + container.getVersion() + " than the requested version " + version + ".");
            }
            if (num == 0) {
                same.add(container);
                continue;
            }
            toUpgrade.add(container);
        }
        for (Container container : same) {
            System.out.println("Container " + container.getId() + " is already at version " + version);
        }
        for (Container container : toUpgrade) {
            Version oldVersion = container.getVersion();
            container.setVersion(version);
            this.log.info("Upgraded container {} from {} to {}", new Object[]{container, oldVersion, version});
            System.out.println("Upgraded container " + container.getId() + " from version " + oldVersion + " to " + version);
        }
        if (this.all) {
            this.fabricService.setDefaultVersion(version);
            System.out.println("Changed default version to " + version);
        }
        return null;
    }
}

