/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands.support;

import java.util.Collections;
import java.util.List;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Agent;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.commands.support.FabricCommand;

public abstract class AgentCreateSupport
extends FabricCommand {
    @Option(name="--version", description="The version id in the registry")
    protected String version = "base";
    @Option(name="--profile", multiValued=true, required=false, description="The profile IDs to associate with the new agent(s)")
    protected List<String> profiles;
    @Option(name="--enable-debuging", multiValued=false, required=false, description="Enable debugging")
    protected Boolean debugAgent = Boolean.FALSE;
    @Option(name="--ensemble-server", multiValued=false, required=false, description="Whether the agent should be a new ZooKeeper ensemble server")
    protected Boolean isClusterServer = Boolean.FALSE;

    public List<String> getProfileNames() {
        List<String> names = this.profiles;
        if (names == null || names.isEmpty()) {
            names = Collections.singletonList("default");
        }
        return names;
    }

    protected void setProfiles(Agent[] children) {
        List<String> names = this.getProfileNames();
        try {
            Profile[] profiles = this.getProfiles(this.version, names);
            for (Agent child : children) {
                child.setProfiles(profiles);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

