/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.fusesource.fabric.internal.ZooKeeperUtils;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.linkedin.zookeeper.client.IZKClient;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(name="join", scope="fabric", description="Join fabric cluster", detailedDescription="classpath:join.txt")
public class Join
extends OsgiCommandSupport {
    ConfigurationAdmin configurationAdmin;
    private IZKClient zooKeeper;
    private String version = "base";
    @Argument(required=true, multiValued=false, description="Zookeeper URL")
    private String zookeeperUrl;

    protected Object doExecute() throws Exception {
        Configuration config = this.configurationAdmin.getConfiguration("org.fusesource.fabric.zookeeper");
        Properties properties = new Properties();
        properties.put("zookeeper.url", this.zookeeperUrl);
        config.setBundleLocation(null);
        config.update((Dictionary)properties);
        Thread.sleep(2000L);
        String karafName = System.getProperty("karaf.name");
        ZooKeeperUtils.createDefault((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_AGENT.getPath(new String[]{karafName}), (String)this.version);
        ZooKeeperUtils.createDefault((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_VERSIONS_AGENT.getPath(new String[]{this.version, karafName}), (String)"default");
        return null;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }
}

