/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.io.PrintStream;
import org.apache.felix.gogo.commands.Command;
import org.fusesource.fabric.api.Agent;
import org.fusesource.fabric.commands.support.FabricCommand;

@Command(name="agent-list", scope="fabric", description="List existing agents")
public class AgentList
extends FabricCommand {
    protected Object doExecute() throws Exception {
        Agent[] agents = this.fabricService.getAgents();
        this.printAgents(agents, System.out);
        return null;
    }

    protected void printAgents(Agent[] agents, PrintStream out) {
        out.println(String.format("%-30s %-10s %-30s %-100s", "[id]", "[alive]", "[profiles]", "[provision status]"));
        for (Agent agent : agents) {
            if (!agent.isRoot()) continue;
            out.println(String.format("%-30s %-10s %-30s %-100s", agent.getId(), agent.isAlive(), this.toString(agent.getProfiles()), agent.getProvisionStatus()));
            for (Agent child : agents) {
                if (child.getParent() != agent) continue;
                out.println(String.format("%-30s %-10s %-30s %-100s", "  " + child.getId(), child.isAlive(), this.toString(child.getProfiles()), agent.getProvisionStatus()));
            }
        }
    }
}

