/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.net.URI;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.CreateAgentArguments;
import org.fusesource.fabric.api.CreateSshAgentArguments;
import org.fusesource.fabric.commands.support.AgentCreateSupport;

@Command(name="agent-create-ssh", scope="fabric", description="Creates one or more new agents via SSH")
public class AgentCreateSsh
extends AgentCreateSupport {
    @Option(name="--host", required=true, description="Host name to SSH into")
    private String host;
    @Option(name="--path", description="Path to use to install the agent")
    private String path;
    @Option(name="--user", description="User name")
    private String user;
    @Option(name="--password", description="Password")
    private String password;
    @Option(name="--port", description="The port number to use to connect over SSH")
    private Integer port;
    @Option(name="--ssh-retries", description="Number of retries to connect on SSH")
    private Integer sshRetries;
    @Option(name="--proxy-uri", description="Maven proxy URL to use")
    private URI proxyUri;
    @Argument(index=0, required=true, description="The name of the agent to be created. When creating multiple agents it serves as a prefix")
    protected String name;
    @Argument(index=1, required=false, description="The number of agents that should be created")
    protected int number = 1;

    protected Object doExecute() throws Exception {
        CreateSshAgentArguments args = new CreateSshAgentArguments();
        args.setClusterServer(this.isClusterServer.booleanValue());
        args.setDebugAgent(this.debugAgent.booleanValue());
        args.setNumber(this.number);
        args.setHost(this.host);
        args.setPath(this.path);
        args.setPassword(this.password);
        args.setProxyUri(this.proxyUri);
        args.setUsername(this.user);
        if (this.port != null) {
            args.setPort(this.port.intValue());
        }
        if (this.sshRetries != null) {
            args.setSshRetries(this.sshRetries.intValue());
        }
        this.fabricService.createAgents((CreateAgentArguments)args, this.name, this.number);
        return null;
    }
}

