/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Agent;
import org.fusesource.fabric.commands.support.AgentCreateSupport;

@Command(name="agent-create", scope="fabric", description="Creates one or more new agents")
public class AgentCreate
extends AgentCreateSupport {
    @Option(name="--parent", multiValued=false, required=false, description="Parent agent ID")
    private String parent;
    @Option(name="--url", multiValued=false, required=false, description="The URL")
    private String url;
    @Argument(index=0, required=true, description="The name of the agent to be created. When creating multiple agents it serves as a prefix")
    protected String name;
    @Argument(index=1, required=false, description="The number of agents that should be created")
    protected int number = 1;

    protected Object doExecute() throws Exception {
        if (this.url == null && this.parent == null) {
            throw new Exception("Either an url or a parent must be specified");
        }
        if (this.url == null && this.parent != null) {
            this.url = "child://" + this.parent;
        }
        Agent[] children = this.fabricService.createAgents(this.url, this.name, this.isClusterServer.booleanValue(), this.debugAgent.booleanValue(), this.number);
        this.setProfiles(children);
        return null;
    }
}

