/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.camel;

import org.apache.camel.impl.DefaultComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.fabric.camel.MasterComponent;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.internal.ZKClient;
import org.linkedin.util.clock.Timespan;

public abstract class ZKComponentSupport
extends DefaultComponent {
    private static final transient Log LOG = LogFactory.getLog(MasterComponent.class);
    private IZKClient zkClient;
    private boolean shouldCloseZkClient = false;
    private long maximumConnectionTimeout = 10000L;

    public IZKClient getZkClient() {
        return this.zkClient;
    }

    public void setZkClient(IZKClient zkClient) {
        this.zkClient = zkClient;
    }

    public boolean isShouldCloseZkClient() {
        return this.shouldCloseZkClient;
    }

    public void setShouldCloseZkClient(boolean shouldCloseZkClient) {
        this.shouldCloseZkClient = shouldCloseZkClient;
    }

    public long getMaximumConnectionTimeout() {
        return this.maximumConnectionTimeout;
    }

    public void setMaximumConnectionTimeout(long maximumConnectionTimeout) {
        this.maximumConnectionTimeout = maximumConnectionTimeout;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.zkClient == null) {
            try {
                this.zkClient = (IZKClient)this.getCamelContext().getRegistry().lookup("zkClient");
            }
            catch (Exception exception) {
                this.zkClient = (IZKClient)this.getCamelContext().getRegistry().lookup(IZKClient.class.getName());
            }
            if (this.zkClient != null) {
                LOG.debug((Object)("IZKClient found in camel registry. " + this.zkClient));
            }
        }
        if (this.zkClient == null) {
            String connectString = System.getProperty("zookeeper.url", "localhost:2181");
            LOG.debug((Object)("IZKClient not find in camel registry, creating new with connection " + connectString));
            ZKClient client = new ZKClient(connectString, Timespan.parse((String)"10s"), null);
            LOG.debug((Object)("Starting IZKClient " + this.zkClient));
            client.start();
            this.zkClient = client;
            this.setShouldCloseZkClient(true);
        }
        this.zkClient.waitForConnected(new Timespan(this.getMaximumConnectionTimeout()));
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.zkClient != null && this.isShouldCloseZkClient()) {
            this.zkClient.close();
        }
    }
}

