/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.camel;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.util.ObjectHelper;
import org.fusesource.fabric.camel.MasterEndpoint;
import org.fusesource.fabric.camel.ZKComponentSupport;
import org.fusesource.fabric.groups.Group;
import org.fusesource.fabric.groups.ZooKeeperGroupFactory;
import org.fusesource.fabric.zookeeper.IZKClient;

public class MasterComponent
extends ZKComponentSupport {
    private String zkRoot = "/fabric/registry/camel/master";

    public String getZkRoot() {
        return this.zkRoot;
    }

    public void setZkRoot(String zkRoot) {
        this.zkRoot = zkRoot;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> params) throws Exception {
        int idx = remaining.indexOf(58);
        if (idx <= 0) {
            throw new IllegalArgumentException("Missing : in URI so can't split the group name from the actual URI for '" + remaining + "'");
        }
        String name = remaining.substring(0, idx);
        String fabricPath = this.getFabricPath(name);
        String childUri = remaining.substring(idx + 1);
        Group group = ZooKeeperGroupFactory.create((IZKClient)this.getZkClient(), (String)fabricPath);
        return new MasterEndpoint(uri, this, name, group, childUri);
    }

    protected String getFabricPath(String name) {
        String path = name;
        if (ObjectHelper.isNotEmpty((Object)this.zkRoot)) {
            path = this.zkRoot + "/" + name;
        }
        return path;
    }
}

