/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.camel;

import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.fusesource.fabric.camel.DefaultLoadBalancerFactory;
import org.fusesource.fabric.camel.FabricLocatorEndpoint;
import org.fusesource.fabric.camel.FabricPublisherEndpoint;
import org.fusesource.fabric.camel.LoadBalancerFactory;
import org.fusesource.fabric.groups.Group;
import org.fusesource.fabric.groups.ZooKeeperGroupFactory;
import org.linkedin.util.clock.Timespan;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.ZKClient;
import org.springframework.beans.factory.annotation.Autowired;

public class FabricComponent
extends DefaultComponent {
    private static final transient Log LOG = LogFactory.getLog(FabricComponent.class);
    @Autowired
    private IZKClient zkClient;
    private String zkRoot = "/fabric/camel/endpoints";
    private List<ACL> accessControlList = ZooDefs.Ids.OPEN_ACL_UNSAFE;
    private LoadBalancerFactory loadBalancerFactory = new DefaultLoadBalancerFactory();
    private ProducerCache producerCache;
    private int cacheSize = 1000;

    public IZKClient getZkClient() {
        return this.zkClient;
    }

    public void setZkClient(IZKClient zkClient) {
        this.zkClient = zkClient;
    }

    public String getZkRoot() {
        return this.zkRoot;
    }

    public void setZkRoot(String zkRoot) {
        this.zkRoot = zkRoot;
    }

    public List<ACL> getAccessControlList() {
        return this.accessControlList;
    }

    public void setAccessControlList(List<ACL> accessControlList) {
        this.accessControlList = accessControlList;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public ProducerCache getProducerCache() {
        return this.producerCache;
    }

    public void setProducerCache(ProducerCache producerCache) {
        this.producerCache = producerCache;
    }

    public LoadBalancerFactory getLoadBalancerFactory() {
        return this.loadBalancerFactory;
    }

    public void setLoadBalancerFactory(LoadBalancerFactory loadBalancerFactory) {
        this.loadBalancerFactory = loadBalancerFactory;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.zkClient == null) {
            this.zkClient = (IZKClient)this.getCamelContext().getRegistry().lookup(IZKClient.class.getName());
            LOG.debug((Object)"IZKClient find in camel registry.");
        }
        if (this.zkClient == null) {
            ZKClient client = new ZKClient(System.getProperty("zookeeper.url", "localhost:2181"), Timespan.parse((String)"10s"), null);
            LOG.debug((Object)"IZKClient not find in camel registry and created.");
            client.start();
            this.zkClient = client;
        }
        this.checkZkConnected();
        if (this.producerCache == null) {
            this.producerCache = new ProducerCache((Object)this, this.getCamelContext(), this.cacheSize);
        }
        ServiceHelper.startService((Object)this.producerCache);
    }

    protected void checkZkConnected() throws Exception {
        if (!this.zkClient.isConnected()) {
            throw new Exception("Could not connect to ZooKeeper " + this.zkClient);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.zkClient != null) {
            this.zkClient.close();
        }
        ServiceHelper.stopService((Object)this.producerCache);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> params) throws Exception {
        int idx = remaining.indexOf(58);
        if (idx > 0) {
            String name = remaining.substring(0, idx);
            String fabricPath = this.getFabricPath(name);
            String childUri = remaining.substring(idx + 1);
            Group group = ZooKeeperGroupFactory.create((IZKClient)this.getZkClient(), (String)fabricPath, this.accessControlList);
            return new FabricPublisherEndpoint(uri, this, group, childUri);
        }
        String fabricPath = this.getFabricPath(remaining);
        Group group = ZooKeeperGroupFactory.create((IZKClient)this.getZkClient(), (String)fabricPath, this.accessControlList);
        return new FabricLocatorEndpoint(uri, this, group);
    }

    protected String getFabricPath(String name) {
        String path = name;
        if (ObjectHelper.isNotEmpty((Object)this.zkRoot)) {
            path = this.zkRoot + "/" + name;
        }
        return path;
    }
}

