/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.boot.commands.support;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.linkedin.zookeeper.client.IZKClient;
import org.osgi.service.cm.ConfigurationAdmin;

public abstract class FabricCommand
extends OsgiCommandSupport {
    private IZKClient zooKeeper;
    protected FabricService fabricService;
    protected ConfigurationAdmin configurationAdmin;
    protected static String AGENT_PID = "org.fusesource.fabric.agent";

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    protected void checkFabricAvailable() throws Exception {
    }

    protected String toString(Profile[] profiles) {
        if (profiles == null) {
            return "";
        }
        int iMax = profiles.length - 1;
        if (iMax == -1) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (true) {
            b.append(profiles[i].getId());
            if (i == iMax) {
                return b.toString();
            }
            b.append(", ");
            ++i;
        }
    }

    protected Profile[] getProfiles(String version, List<String> names) {
        return this.getProfiles(this.fabricService.getVersion(version), names);
    }

    protected Profile[] getProfiles(Version version, List<String> names) {
        Profile[] allProfiles = version.getProfiles();
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        if (names == null) {
            return new Profile[0];
        }
        for (String name : names) {
            Profile profile = null;
            for (Profile p : allProfiles) {
                if (!name.equals(p.getId())) continue;
                profile = p;
                break;
            }
            if (profile == null) {
                throw new IllegalArgumentException("Profile " + name + " not found.");
            }
            profiles.add(profile);
        }
        return profiles.toArray(new Profile[profiles.size()]);
    }

    protected Profile getProfile(Version ver, String name) {
        Profile p = ver.getProfile(name);
        if (p == null) {
            throw new IllegalArgumentException("Profile " + name + " does not exist.");
        }
        return p;
    }

    protected Container getContainer(String name) {
        Container[] containers;
        for (Container container : containers = this.fabricService.getContainers()) {
            if (!container.getId().equals(name)) continue;
            return container;
        }
        throw new IllegalArgumentException("Container " + name + " does not exist.");
    }

    protected boolean doesContainerExist(String name) {
        Container[] containers;
        for (Container container : containers = this.fabricService.getContainers()) {
            if (!container.getId().equals(name)) continue;
            return true;
        }
        return false;
    }

    protected String percentText(double value) {
        return NumberFormat.getPercentInstance().format(value);
    }
}

