/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab.osgi.bnd;

import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Processor;
import aQute.lib.spring.XMLType;
import aQute.lib.spring.XMLTypeProcessor;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathImportsHandlerPlugin
extends XMLTypeProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassPathImportsHandlerPlugin.class);

    @Override
    protected List<XMLType> getTypes(Analyzer analyzer) throws Exception {
        ArrayList<XMLType> types = new ArrayList<XMLType>();
        try {
            String header = analyzer.getProperty("Spring-Context", "META-INF/spring");
            this.process(types, "imports.xsl", header, ".*\\.xml");
        }
        catch (Exception e) {
            LOGGER.warn("Error while adding bundle imports for Spring <import/> elements", (Throwable)e);
        }
        return types;
    }

    @Override
    protected void process(List<XMLType> types, String resource, String paths, String pattern) throws Exception {
        Map<String, Map<String, String>> map = Processor.parseHeader(paths, null);
        for (String path : map.keySet()) {
            types.add(new ClassPathImportsXmlType(this.getClass().getResource(resource), path, pattern));
        }
    }

    private class ClassPathImportsXmlType
    extends XMLType {
        public ClassPathImportsXmlType(URL source, String root, String paths) throws Exception {
            super(source, root, paths);
        }

        @Override
        public Set<String> analyze(InputStream in) throws Exception {
            Set<String> refers = super.analyze(in);
            return this.transformToJavaNotation(refers);
        }

        private Set<String> transformToJavaNotation(Set<String> refers) {
            HashSet<String> result = new HashSet<String>();
            for (String refer : refers) {
                try {
                    if (!refer.startsWith("classpath:")) continue;
                    String folder = refer.substring(10, refer.lastIndexOf("/"));
                    result.add(folder.replaceAll("/", "."));
                }
                catch (Exception e) {
                    LOGGER.warn(String.format("Unable to add bundle import to match <import resource='%s'/>", refer), (Throwable)e);
                }
            }
            return result;
        }
    }
}

